<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Initialize a nx device..

    .DESCRIPTION
        Initialize a nx device..
#>
[CmdletBinding()]
Param
(
  [string]
  $BuildType = 'Develop',
    
  [string]
  $Platform = 'NX-NXFP2-a64',

  [string]
  $KeyType = 'Auto', # K1, K2, Auto
  
  [string]
  $ConnectionType = 'Hb', # Hb, Usb
  
  [string]
  $BootType = 'Nand', # Nand, List
  
  [string]
  $SignedType = 'Unsigned', # Unsigned, Signed
  
  [string]
  $StorageSize = '64G', # 32G, 64G 
  
  [string]
  $DeveloperType = 'Internal', # Internal, Public    
    
  [string]
  $BootConfig = 'Skip', # Skip, <BootConfigFile>

  [string]
  $AddressPattern = '',

  [switch]
  $Build = $false,

  [string]
  $LabelFile = '',

  [string]
  $RecoveryConnectionType = '', # Hb, Usb

  [switch]
  $SkipHelloWorld = $false,

  [switch]
  $SkipStopTargetManager = $false,

  [switch]
  $SkipStopProcessesForCi = $false
)

$scriptPath = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)

Import-Module "${scriptDirectoryPath}/../../Modules/Error"
Import-Module "${scriptDirectoryPath}/../../Modules/Path"
Import-Module "${scriptDirectoryPath}/../../Modules/HostBridge"
Import-Module "${scriptDirectoryPath}/../../Modules/Utility"
Import-Module "${scriptDirectoryPath}/../../Modules/Runner"
Import-Module "${scriptDirectoryPath}/../../Modules/InitializeTarget"
Import-Module "${scriptDirectoryPath}/../../Modules/UsbTarget"

trap [Exception] {
  Write-ErrorRecord $_
  exit 1
}

$InvokeNact = "$scriptDirectoryPath/../../Invoke-Nact.ps1"
$InitializeEdevRaw = "$($scriptDirectoryPath)/Initialize-Edev-Full-Raw.ps1"
$InitializeSdevRaw = "$($scriptDirectoryPath)/Initialize-Sdev-Full-Raw.ps1"

if ($RecoveryConnectionType -eq '') {
  if ($ConnectionType -eq "Hb" -or $ConnectionType -eq "Usb") {
    $RecoveryConnectionType = $ConnectionType
  }
  else {
    throw "Needs RecoveryConnectionType because ConnectionType = `"$ConnectionType`". Example: `"-RecoveryConnectionType Hb`" or `"-RecoveryConnectionType Usb`""
  }
}

if ($RecoveryConnectionType -eq "Hb" -and $AddressPattern -eq '') {
  throw "Needs AddressPattern. Example: '-AddressPattern `"169.254.8.104`"`' or '-AddressPattern `"169.*`"`'"
}

if ($Build) {
  pushd $(Get-NintendoSdkRootPath)
  Invoke-CriticalCommand "& $InvokeNact BUILD=$BuildType specs=NX platforms=NXFP2-a64 -LocalExecutionMode --build_source_file $(Get-NintendoSdkRootPath)/$LabelFile"
  popd
}

if ($RecoveryConnectionType -eq 'Hb') {
  Invoke-CriticalCommand "& `"$InitializeSdevRaw`" -BootConfig `"$BootConfig`" -AddressPattern $AddressPattern -BuildType $BuildType -Platform $Platform -KeyType $KeyType -ConnectionType $ConnectionType -RecoveryConnectionType $RecoveryConnectionType -BootType $BootType -SignedType $SignedType -StorageSize $StorageSize -DeveloperType $DeveloperType -SkipStopTargetManager:`$$SkipStopTargetManager -SkipStopProcessesForCi:`$$SkipStopProcessesForCi -SkipHelloWorld:`$$SkipHelloWorld"
}
elseif ($RecoveryConnectionType -eq 'Usb') {
  Invoke-CriticalCommand "& `"$InitializeEdevRaw`" -BootConfig `"$BootConfig`" -BuildType $BuildType -Platform $Platform -KeyType $KeyType -ConnectionType $ConnectionType -BootType $BootType -SignedType $SignedType -StorageSize $StorageSize -DeveloperType $DeveloperType -SkipStopTargetManager:`$$SkipStopTargetManager -SkipStopProcessesForCi:`$$SkipStopProcessesForCi"
}
else {
  throw "Unsupported RecoveryConnectionType: $RecoveryConnectionType"
}

