<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Initialize CopperEP1 by system updater.

    .DESCRIPTION
        Initialize CopperEP1 by system updater.
#>
[CmdletBinding()]
Param
(
    [string]
    $BuildType = 'Develop',
    
    [string]
    $Platform = 'NX-NXFP2-a64'
)

$KeyType = "K5"
$BootType = "Nand"
$SignedType = "Signed"
$StorageSize = "32G"
$DeveloperType = "Internal"

$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($MyInvocation.MyCommand.Path)

$InitializeEdevRaw    = "$($scriptDirectoryPath)/Initialize-Edev-Full-Raw.ps1"

Invoke-Expression "& `"$InitializeEdevRaw`" -BuildType $BuildType -Platform $Platform -KeyType $KeyType -BootType $BootType -SignedType $SignedType -StorageSize $StorageSize -DeveloperType $DeveloperType"
