﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Sign module

    .DESCRIPTION
        Send a target file to the server
#>

function SignFile {
    param (
        [parameter(Mandatory=$True,Position=1)] [ValidateScript({ Test-Path -PathType Leaf $_ })] [String] $InFile,
        [parameter(Mandatory=$True,Position=2)] [String] $OutFile,
        [parameter(Mandatory=$True,Position=3)] [System.URI] $URL,
        [parameter(Mandatory=$False,Position=4)] [System.Net.NetworkCredential] $Credential
    )

    # エラー時に例外を発生させるようにする
    $ErrorActionPreference = "Stop"

    # ルートCA の検証を無効化
    add-type @"
        using System.Net;
        using System.Security.Cryptography.X509Certificates;

            public class IDontCarePolicy : ICertificatePolicy {
            public IDontCarePolicy() {}
            public bool CheckValidationResult(
                ServicePoint sPoint, X509Certificate cert,
                WebRequest wRequest, int certProb) {
                return true;
            }
        }
"@
    [System.Net.ServicePointManager]::CertificatePolicy = new-object IDontCarePolicy
    [System.Net.ServicePointManager]::SecurityProtocol = [System.Net.SecurityProtocolType]::Tls
    [System.Net.ServicePointManager]::DefaultConnectionLimit  = 1
    [System.Net.ServicePointManager]::MaxServicePoints = 0
    [System.Net.ServicePointManager]::MaxServicePointIdleTime = 1000 * 60
    [System.Net.ServicePointManager]::SetTcpKeepAlive($False, 0, 0)

    # mime/multipart の処理
    $Boundary   = [System.Guid]::NewGuid().ToString()
    $LF         = "`r`n"
    $AuthString = [Convert]::ToBase64String([Text.Encoding]::ASCII.GetBytes($Credential.UserName + ":" + $Credential.Password))

    [int]$Trials = 0
    do {
        $Trials += 1

        [System.Net.HttpWebRequest] $Request = [System.Net.WebRequest]::create($URL)
        $Request.Method         = "POST"
        $Request.ContentType    = "multipart/form-data; boundary=$Boundary"
        $ContentLength          = 0
        $Request.TimeOut        = 120000
        $Request.KeepAlive      = $False;
        $Request.Headers.Add("Authorization", "Basic " + $AuthString)

        try {
            $RequestStream  = $Request.getRequestStream()
            $Filename       = [System.IO.Path]::GetFileName($InFile)
            $HeaderLines    = (
                "--$Boundary",
                "Content-Type: application/octet-stream",
                "Content-Transfer-Encoding: binary",
                "Content-Disposition: form-data; name=`"content`"; filename=`"$Filename`"",
                "$LF"
            ) -join $LF
            $Buffer = [Text.Encoding]::ASCII.GetBytes($HeaderLines)
            $RequestStream.Write($Buffer, 0, $Buffer.length)

            $Data = [System.IO.File]::ReadAllBytes($InFile)
            $RequestStream.Write($Data, 0, $Data.length)

            $HeaderLines = (
                "",
                "--$Boundary--$LF"
                ) -join $LF
            $Buffer = [Text.Encoding]::ASCII.GetBytes($HeaderLines)
            $RequestStream.Write($Buffer, 0, $Buffer.length)
            $RequestStream.Close()

            # 応答の取得処理
            [Net.httpWebResponse] $Response = $Request.getResponse()
            $ResponseStream = $Response.GetResponseStream()

            $OutFileHandle = [System.IO.File]::Create($OutFile)
            $Buffer = New-Object Byte[] 1024
            Do {
                $ReadData = $ResponseStream.Read($Buffer, 0, $Buffer.Length)
                $OutFileHandle.Write($Buffer, 0, $ReadData)
            } While ($ReadData -gt 0)

            $ResponseStream.Close()
            $OutFileHandle.Close()
            $Response.Close();

            Exit 0
        }
        catch [Net.WebException] {
            Write-Host $_.Exception.ToString()
            Write-Host Retry $Trials "(Sleep 10 sec)"
            $Request.Abort()
            Start-Sleep -s 10
        } finally {
        }
    } while($Trials -lt 5)
    Write-Host Sign fail
    Exit 1
}

Export-ModuleMember -Function SignFile