﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        MakeLink Module

    .DESCRIPTION
        This file defines functions for mklink operations
#>

function New-HardLink
{
    param
    (
        [Parameter(Mandatory=$true)]
        [string]
        # New link
        $NewLink,

        [Parameter(Mandatory=$true)]
        [string]
        # Source
        $Source
    )

    $code = @"
using System;
using System.Runtime.InteropServices;

namespace MakeLink
{
    public class Util
    {
        [DllImport("Kernel32.dll", CharSet = CharSet.Unicode)]
        static extern bool CreateHardLink(
        string lpFileName,
        string lpExistingFileName,
        IntPtr lpSecurityAttributes
        );
        public static void CreateHardLink(string newlink, string source)
        {
            var result = CreateHardLink(newlink, source, IntPtr.Zero);
            if (!result)
            {
                throw new Exception("ハードリンクの作成に失敗しました。");
            }
        }
    }
}
"@

    Add-Type -Language CSharpVersion3 $code;

    [MakeLink.Util]::CreateHardLink($NewLink, $Source);
}
Export-ModuleMember -Function New-HardLink
