﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        CiAgent Module

    .DESCRIPTION
        This file defines functions for CI agent management
#>

$moduleFilePath = $MyInvocation.MyCommand.Path
$modulePath     = [System.IO.Path]::GetDirectoryName($moduleFilePath)
$moduleRootPath = [System.IO.Path]::GetDirectoryName($modulePath)

Import-Module "${moduleRootPath}\Path"

<#
    .SYNOPSIS
        Returns targets assigned to the CI agent

    .OUTPUTS
        Array instance that contains target information objects.
#>
function Get-CiAgentAssignedTargets
{
    param
    (
        [string]
        # Machine name of the CI agent
        $MachineName = [Environment]::MachineName
    )

    $targets = @()

    $filePath = "$(Get-CiAgentsRootPath)\${MachineName}.xml"

    if (Test-Path $filePath -PathType Leaf)
    {
        $xml = New-Object "Xml.XmlDocument"

        $xml.Load($filePath)

        $xml.SelectNodes("/settings/targets/target") | % {
            $targets += @{
                "Name"      = $_.name
                "Interface" = $_.interface
                "Address"   = $_.address
                "Phidgets"  = $_.phidgets
                "Uart"      = $_.uart
            }
        }
    }

    return ,$targets
}

Export-ModuleMember -Function Get-CiAgentAssignedTargets
