﻿<#
    Copyright (C)Nintendo. All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.
 
    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
    .NET Framework ツールのローカライズ処理を行います。

    .DESCRIPTION
    .NET Framework ツールのローカライズ処理を行います。

    .INPUTS
    なし。

    .OUTPUTS
    なし。
#>
[CmdletBinding()]
Param(
    # 対象のアセンブリがあるディレクトリを指定します。
    [parameter(Mandatory = $true,
               Position = 0)]
    [string] $ApplicationBase,

    # 入力用日本語翻訳項目XMLファイルのパスを指定します。
    [parameter(Mandatory = $true,
               Position = 1)]
    [string] $InputLocalizationItemJa,

    # 入力用英語翻訳項目XMLファイルのパスを指定します。
    [parameter(Mandatory = $true,
               Position = 2)]
    [string] $InputLocalizationItemEn,

    # 出力用日本語翻訳項目XMLファイルのパスを指定します。
    [parameter(Mandatory = $true,
               Position = 3)]
    [string] $OutputLocalizationItemJa,

    # 出力用翻訳マップファイル(xlsx)のパスを指定します。
    [parameter(Mandatory = $true,
               Position = 4)]
    [string] $OutputLocalizationMap,

    # 設定ファイルをのパスを指定します。
    [parameter()]
    [string] $Config,

    # 除外アセンブリパターンを指定します。
    [parameter()]
    [string[]] $Exclude,

    [parameter()]
    [switch] $Snapshot
)

$ErrorActionPreference = "Stop"

$sigloRoot = (Join-Path $MyInvocation.MyCommand.Path ../../../.. | Resolve-Path).Path

Import-Module $sigloRoot/Integrate/Scripts/Modules/Localize
Import-Module $sigloRoot/Integrate/Outputs/AnyCPU/Tools/DotNetLocalizer/DotNetLocalizer/Release/DotNetLocalizer.dll

$privateBinPath = ''

$newExclude = if ($Exclude) { $Exclude } else { @() }

if ($Config) {
    $configXml = [xml](Get-Content $Config -Encoding UTF8)
    $privateBinPath = $configXml.GuiLocalizer.Target.PrivateBinPath

    if ($configXml.GuiLocalizer.Target.Excludes.Exclude) {
        $newExclude +=
            $configXml.GuiLocalizer.Target.Excludes.Exclude |
            ForEach-Object {
                $_.RegExp
            }
    }
}

$jaRes = Import-LocalizationItemXml $InputLocalizationItemJa
$enRes = Import-LocalizationItemXml $InputLocalizationItemEn

$newJaRes = @(
    Get-LocalizationItem `
        -ApplicationBase $ApplicationBase `
        -PrivateBinPath $privateBinPath `
        -Exclude $newExclude)
$newEnRes = Update-LocalizationItem $jaRes $enRes $newJaRes

New-SatelliteAssembly `
    $ApplicationBase `
    $newEnRes `
    -PrivateBinPath $privateBinPath `
    -FillDllWithTemporary

Split-Path $OutputLocalizationItemJa -Parent |
Where-Object { ! (Test-Path $_) } |
ForEach-Object {
    mkdir $_ > $null
}

Export-LocalizationItemXml $OutputLocalizationItemJa $newJaRes

Split-Path $OutputLocalizationMap -Parent |
Where-Object { ! (Test-Path $_) } |
ForEach-Object {
    mkdir $_ > $null
}

if ($Snapshot) {
    $outDir = Split-Path $OutputLocalizationMap -Parent

    Join-Path $outDir images | Where-Object { Test-Path $_ } | ForEach-Object { Remove-Item $_ -Recurse }

    New-XamlSnapshot $ApplicationBase $outDir -PrivateBinPath $privateBinPath -Exclude $newExclude
    New-XamlSnapshot $ApplicationBase $outDir -PrivateBinPath $privateBinPath -Exclude $newExclude -LangEn
}

New-LocalizationMap $OutputLocalizationMap $newJaRes $newEnRes -Snapshot:$Snapshot
