<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Invoke Sleep Test on Target

    .DESCRIPTION
        Run Sleep and Wake Test.
#>

param
(
    [string]
    # Target Address Pattern
    $AddressPattern = $env:TARGET_ADDRESS_PATTERN,

    [string]
    # The platform name
    $Platform,

    [int]
    # The number of seconds before it times out.
    $Timeout = 60,

    [string]
    # The build type
    $BuildType = "Develop",

    [string]
    # Test path
    $Path = "Tests\Outputs\NX-NXFP2-a64\Tests\SleepWakeSequenceTestLowForCi\Develop\SleepWakeSequenceTestLowForCi.nsp"
)

$scriptPath          = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)
Import-Module "${scriptDirectoryPath}\Modules\Error"
Import-Module "${scriptDirectoryPath}\Modules\Path"
Import-Module "${scriptDirectoryPath}\Modules\TargetManager"
Import-Module "${scriptDirectoryPath}\Modules\Runner"
Import-Module "${scriptDirectoryPath}\Modules\HostBridge"
Import-Module "${scriptDirectoryPath}\Modules\Utility"

trap [Exception]
{
    Write-ErrorRecord $_
    exit 1
}

$logDir = [System.IO.Path]::GetFileNameWithoutExtension($scriptPath)
$logDir = "${scriptDirectoryPath}\${logDir}"
$logDir = $logDir.Replace((Get-NintendoSdkIntegrateRootPath), "")
$logDir = (Get-NintendoSdkIntegrateOutputRootPath) + $logDir
$logDir = $logDir + "\" + (Get-Date -Format "yyyyMMddHHmmss")
[void](New-Item $logDir -ItemType Directory -ErrorAction "Stop")

# nsp file full path
$nspname = [System.IO.Path]::Combine((Get-NintendoSdkRootPath), ${Path})

if (-not $AddressPattern)
{
    # If AddressPattern is not specified and env:TARGET_ADDRESS_PATTERN is not difined
    $AddressPattern = "169.*";
}

$TestResult = 1

try
{
    
    $logFile = $logDir + "\" + [System.IO.Path]::GetFileNameWithoutExtension($_) + ".log"
    Write-Host "Start ${_}"
    Write-Host "logFile: ${logFile}"

    # Get the address of the HostBridge
    $TargetAddress = Get-SigleTargetAddress -AddressPattern $AddressPattern
    
    # TORIAEZU : 起動してすぐにテストを走らせるとモジュール登録してないモジュールが死ぬため、暫定的に 5s 待つ
    Start-Sleep -Seconds 10

    # テストを起動 (してすぐ RunOnTarget は終了)
    Invoke-Expression "& `"$(Get-NintendoSdkRootPath)\Tools\CommandLineTools\RunOnTargetPrivate.exe`" run $nspname --failure-timeout $Timeout --verbose --monitor-serial --hostbridge $TargetAddress --no-wait | Set-Content -Passthru $logFile | Write-Host"

    # HostBridge Log の監視
    Invoke-Expression "& `"$(Get-NintendoSdkRootPath)\Tools\CommandLineTools\ReadHostBridgeLog.exe`" --pattern-success-exit `"\[  PASSED  \] .+ tests?.`" --pattern-failure-exit `"\[  FAILED  \]`" --pattern-failure-exit `"\[TestOnTarget\] FAILED`" --pattern-failure-exit `"Assertion Failure:`" --pattern-failure-exit `"Break\(\) called`" --failure-timeout $Timeout --verbose --address $TargetAddress | Set-Content -Passthru $logFile | Write-Host"

    $TestResult = $LastExitCode

    # TORIAEZU: 環境変数を見てリセットする
    if ($TestResult -ne 0 -or $env:REQUIRE_TARGET_RESET -eq "true")
    {
        $ControlTarget = "$(Get-NintendoSdkRootPath)/Tools/CommandLineTools/ControlTarget.exe"
        Invoke-CriticalCommand "& `"$ControlTarget`" reset"
    }
}
finally
{
}

# Pass exitCode to TestRunner's result
exit $TestResult
