﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Install files on tools directory.

    .DESCRIPTION
        Copy files with directory construction.
#>

param
(
    # destination directory
    [Parameter(mandatory=$true, Position=0)]
    [string]
    $DestinationDirectory,

    # source root directory
    [string]
    $SourceRootDirectory = [String]::Empty,

    # source files
    [Parameter(mandatory=$true, Position=1, ValueFromRemainingArguments=$true)]
    [string[]]
    $SourceFiles
)

$scriptPath          = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)

Import-Module "${scriptDirectoryPath}\Modules\Error"
Import-Module "${scriptDirectoryPath}\Modules\Path"

trap [Exception]
{
    Write-ErrorRecord $_
    exit 1
}

$sourceRoot = [String]::Empty
if (![String]::IsNullOrEmpty($SourceRootDirectory))
{
    $sourceRoot = $SourceRootDirectory.Replace("\\", "\").Trim("\") + "\"
}

$SourceFiles |% {
    $source = $_.Replace("\\", "\")
    $finalDestinationDirectory = $DestinationDirectory.Replace("\\", "\")
    if (![String]::IsNullOrEmpty($sourceRoot))
    {
        if ($source.StartsWith($sourceRoot, [StringComparison]::OrdinalIgnoreCase))
        {
            $relativePath = [System.IO.Path]::GetDirectoryName($source).Replace("\\", "\").SubString($sourceRoot.Trim("\").Length).Trim("\")
            $finalDestinationDirectory = [System.IO.Path]::Combine($finalDestinationDirectory, $relativePath)
        }
        else
        {
            # コピー対象のファイルが基準ディレクトリ以下に無い場合、想定した使い方ではないためエラーにする
            throw [String]::Format("Copy target file '{0}' is not found in '{1}'.", $source, $sourceRoot)
        }
    }

    if (!(Test-Path $finalDestinationDirectory))
    {
        New-Item $finalDestinationDirectory -ItemType Directory
    }

    Copy-Item -Path $source -Destination $finalDestinationDirectory
}
