﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Get TeamCityBuildLog

    .DESCRIPTION
        Get TeamCity build log from TeamCity server.
#>

Param(
  # TeamCity のサーバ URL を指定します。
  [string]
  $Url,

  # 認証情報が書かれた設定ファイルを指定します
  # 以下、設定ファイルのサンプルです
  # <?xml version="1.0"?>
  # <Configuration>
  #   <User>ユーザ名</User>
  #   <Password>パスワード</Password>
  # </Configuration>
  [string]$AuthenticationFile,

  # ログ取得対象のビルド ID を指定します。
  [string]$BuildId,

  # 出力先ファイル名を指定子ます。
  [string]$OutputFile
)

$scriptPath          = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)

Import-Module "${ScriptDirectoryPath}\Modules\Error"
Import-Module "${scriptDirectoryPath}\Modules\TeamCity"

# 例外ハンドラ
trap [Exception]
{
    Write-ErrorRecord $_
    exit 1
}

if ([string]::IsNullOrEmpty($Url))
{
    throw "Url が指定されていません"
}

if ([string]::IsNullOrEmpty($AuthenticationFile))
{
    throw "AuthenticationFile が指定されていません"
}

if ([string]::IsNullOrEmpty($BuildId))
{
    throw "BuildId が指定されていません"
}

if ([string]::IsNullOrEmpty($OutputFile))
{
    throw "OutputFile が指定されていません"
}

$authFile = [xml](Get-Content $AuthenticationFile -ErrorAction Stop)
$userName = $authFile.Configuration.User
$password = $authFile.Configuration.Password

$log = Get-TeamCityBuildLog -Url $Url -UserName $userName -Password $password -BuildId $BuildId

$log | Set-Content $OutputFile -Encoding UTF8 -ErrorAction Stop
