﻿<#
    Copyright (C)Nintendo. All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.
 
    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS

    .DESCRIPTION

    .INPUTS
    なし。

    .OUTPUTS
    なし。
#>
[CmdletBinding()]
Param(
    # 入力ファイル。
    [parameter(Mandatory = $true,
               Position = 0)]
    [string] $InputFile,

    # 出力ファイル。指定が無ければ入力ファイル名から生成する
    [parameter(Mandatory = $true,
               Position = 1)]
    [string] $OutputFile,

    # APIリファレンスの置換先のパスを指定します。
    [parameter()]
    [string] $ReplaceApiReferencePath,

    # 依存先APIリファレンスの置換先のパスを指定します。
    [parameter()]
    [string] $ReplaceDependApiReferencePath,

    # プライベート用APIリファレンスの切り分けのためのDoxygenのTagファイルを指定します。
    [parameter()]
    [string] $DoxyTag
)

$scriptDir = Split-Path $MyInvocation.MyCommand.Path -Parent
$sigloRoot = (Join-Path $MyInvocation.MyCommand.Path ../../../.. | Resolve-Path).Path

Import-Module $sigloRoot/Integrate/Outputs/AnyCPU/Tools/AddApiLinkSpan/AddApiLinkSpan/Release/AddApiLinkSpan.psd1

if (!$InputFile) {
    $InputFile = Join-Path $sigloRoot Documents\SIGLODOC\entities.xml
}
if (! $OutputFile) {
    $OutputFile = Join-Path $sigloRoot Documents\SIGLODOC\entities.output.xml
}
Add-ApiLinkSpan -InputFile $InputFile -OutputFile $OutputFile -ReplaceApiReferencePath $ReplaceApiReferencePath `
    -ReplaceDependApiReferencePath $ReplaceDependApiReferencePath -DoxyTag $DoxyTag
