#!/bin/sh

# This is a helper script for the exbisect Git alias script.
# It is copied into the .git folder so that it isn't removed during a bisect.
# Exbisect is used to automate Git bisect in the Siglo repository.
# Do not call this script directly. Use "git exbisect <commit> <script>".
# <commit> is a known good commit (assuming the current commit is bad).
# <script> is a script that should return 0 for a good commit and 1 for a bad commit.
#
# For more information, see the Git Recipes confluence page:
# http://spdlybra.nintendo.co.jp/confluence/x/LyCEBg

# Display current commit being checked
echo
echo Current commit:
git log -1 --oneline

# Update submodules
echo "Updating submodules..."
git submodule update --init --recursive

# Check repo and exrepo statuses, and clean if necessary
echo "Confirming repository is clean..."
if [ -n "$( git status --porcelain && git exforeach 'git -C {} status --porcelain')" ]; then 
  echo "Changes detected, cleaning"; 
  git exclean
else 
  echo "Repository clean";
fi

# Update toolchains
echo "Updating toolchains..."
powershell -ExecutionPolicy RemoteSigned "Integrate\Scripts\Setup-ToolChain.ps1"

# Run script provided by user
sh -c $*
returnValue=$?
echo "Return value: $returnValue"
echo
exit $returnValue
