﻿# ==============================================================================
# 管理者権限でインストール処理 (InstallImpl.ps1) を実行します
# ==============================================================================

Param(
    [parameter(mandatory="")]
    [string]$vsixDir,

    [string]$windowStyle
)

$scriptPath = $MYInvocation.MyCommand.Path
$scriptDir = Split-Path -Parent $scriptPath

$logFilePath = "$scriptDir/_log.txt"


# ------------------------------------------------------------------------------
# MEMO:
# PowerShell 2.0 環境 (Windows 7 のデフォルトバージョン) では、次のようなコードで
# $ret (= $proc.ExitCode) が取得できないため、以下 (*1) のような書き下したコードで
# 実現しています。
### $proc = Start-Process -WindowStyle $windowStyle -FilePath "powershell.exe" -ArgumentList "-ExecutionPolicy RemoteSigned `"$scriptDir/InstallImpl.ps1 -vsixDir $vsixDir` 2>&1 | tee-object -file `"$logFilePath`"; exit `$LASTEXITCODE" -Verb runas -PassThru
### $proc.WaitForExit()
### $ret = $proc.ExitCode

# (*1) ↑ を書き下したコード
$pinfo = New-Object System.Diagnostics.ProcessStartInfo
$pinfo.FileName = "powershell.exe"
$pinfo.RedirectStandardError = $false
$pinfo.RedirectStandardOutput = $false
$pinfo.UseShellExecute = $true
$pinfo.Arguments = "-ExecutionPolicy RemoteSigned `"$scriptDir/InstallImpl.ps1`" -vsixDir $vsixDir -install true 2>&1 | tee-object -file `"$logFilePath`""
$pinfo.Verb = "runas"
$p = New-Object System.Diagnostics.Process
$p.StartInfo = $pinfo
$p.Start() | Out-Null
$p.WaitForExit()
$ret = $p.ExitCode
# ------------------------------------------------------------------------------


cat $logFilePath

exit $ret
