@echo off

rem ウィザードのアンインストールは行いませんので、このスクリプトは呼び出されません

rem %1 ... SDK ルートディレクトリパス

set SDK_ROOT_DIR=%1


call :DeleteWizards "%USERPROFILE%\Documents\Visual Studio 2012" 11.0
call :DeleteWizards "%USERPROFILE%\Documents\Visual Studio 2013" 12.0
call :DeleteWizards "%USERPROFILE%\Documents\Visual Studio 2015" 14.0
call :DeleteWizards "%USERPROFILE%\Documents\Visual Studio 2017" 15.0

exit /b 0


REM ---- ウィザードの削除
REM %1 ... デフォルトパス
REM %2 ... VisualStudio のバージョン

:DeleteWizards
setlocal enabledelayedexpansion
set DEFAULT_PATH=%1
set VS_VERSION=%2

call :GetWizardDestinationDirectory %DEFAULT_PATH% %VS_VERSION%

set DEST_PATH=!WIZARD_DESTINATION_BASE_DIRECTORY!

set WIZARD_CONFIG_PATH=%DEST_PATH%\Wizards\NintendoSDK

if exist "%WIZARD_CONFIG_PATH%" (
    rmdir /s /q "%WIZARD_CONFIG_PATH%"
)

set APP_DEST_PATH=%DEST_PATH%\NintendoSDK\CustomWizard\NintendoSdkApplicationCustomWizard

if exist "%APP_DEST_PATH%" (
    rmdir /s /q "%APP_DEST_PATH%"
)

set LIB_DEST_PATH=%DEST_PATH%\NintendoSDK\CustomWizard\NintendoSdkLibraryCustomWizard

if exist "%LIB_DEST_PATH%" (
    rmdir /s /q "%LIB_DEST_PATH%"
)

exit /b


REM ---- 必要となるレジストリハイブをロードする (VS2017対応)
REM %1 ... レジストリハイブのロードキー
REM %2 ... VisualStudio のバージョン番号

:PrepareForLoadHive
setlocal enabledelayedexpansion
set TARGET_REGISTORY_HIVE_KEY=%1
set VS_VERSION=%2

set VSWHERE_VERSION_STRING=

if %VS_VERSION% == 15 (
    set VSWHERE_VERSION_STRING=[15.0,16.0^)
)

for /f "usebackq delims=" %%a in (`"C:\Program Files (x86)\Microsoft Visual Studio\Installer\vswhere" -format value -property instanceId -version !VSWHERE_VERSION_STRING! -products Microsoft.VisualStudio.Product.Professional`) do set VS_INSTANCE_ID=%%a

if "%VS_INSTANCE_ID%" == "" (
    echo Visual Studio v%VS_VERSION% Professional is not installed.
    exit /b 1
)

reg load %TARGET_REGISTORY_HIVE_KEY% %LocalAppData%\Microsoft\VisualStudio\15.0_%VS_INSTANCE_ID%\privateregistry.bin

exit /b 0


REM ---- 必要となるレジストリハイブをロードする (VS2017対応)
REM %1 ... レジストリハイブのロードキー

:FinalizeForLoadHive
setlocal enabledelayedexpansion
set TARGET_REGISTORY_HIVE_KEY=%1

reg query %TARGET_REGISTORY_HIVE_KEY%

if !ERRORLEVEL! == 0 (
    reg unload %TARGET_REGISTORY_HIVE_KEY%
)

exit /b 0


REM ---- ウィザードのコピー先ディレクトリの取得
REM      (%WIZARD_DESTINATION_BASE_DIRECTORY% に保存されます)
REM %1 ... 取得できなかった場合のデフォルトパス
REM %2 ... VisualStudio のバージョン番号

:GetWizardDestinationDirectory
setlocal enabledelayedexpansion
set DEFAULT_PATH=%1
set VS_VERSION=%2

set WIZARD_DESTINATION_BASE_DIRECTORY=

rem set TARGET_REGISTORY_KEY=
rem set TARGET_REGISTORY_VALUE=VisualStudioLocation
set TARGET_REGISTRY_DATA=
set VS_INSTANCE_ID=

if "%VS_VERSION%"=="12.0" (
    call :GetRegistryData HKCU\Software\Microsoft\VisualStudio\12.0 VisualStudioLocation
) else if "%VS_VERSION%"=="14.0" (
    call :GetRegistryData HKCU\Software\Microsoft\VisualStudio\14.0 VisualStudioLocation
) else if "%VS_VERSION%"=="15.0" (
    call :GetVsInstanceId 15.0
    call :GetRegistryDataFromHive VisualStudioLocation 15.0 !VS_INSTANCE_ID!
) else (
    endlocal
    exit /b 1
)

REM ---- %USERPROFILE%の展開処理
echo set TARGET_REGISTRY_DATA="%TARGET_REGISTRY_DATA%">temp.bat
call temp.bat
del temp.bat

set WIZARD_DESTINATION_BASE_DIRECTORY=%TARGET_REGISTRY_DATA%

if %WIZARD_DESTINATION_BASE_DIRECTORY% == "" (
    set WIZARD_DESTINATION_BASE_DIRECTORY=%DEFAULT_PATH%
)
set WIZARD_DESTINATION_BASE_DIRECTORY=%WIZARD_DESTINATION_BASE_DIRECTORY:"=%

endlocal & (set WIZARD_DESTINATION_BASE_DIRECTORY=%WIZARD_DESTINATION_BASE_DIRECTORY%)

exit /b 0


REM ---- レジストリから値を取得する
REM      (%TARGET_REGISTRY_DATA% に保存されます)
REM %1 ... レジストリキー
REM %2 ... レジストリ値名

:GetRegistryData
set REGISTRY_KEY=%1
set REGISTRY_VALUE=%2

set TARGET_REGISTRY_DATA=
for /F "TOKENS=1,2,*" %%A IN ('reg query "%REGISTRY_KEY%" /reg:32 /v "%REGISTRY_VALUE%" 2^> nul') do if "%%A"=="%REGISTRY_VALUE%" set TARGET_REGISTRY_DATA=%%C

exit /b 0


REM ---- Visual Studio の InstanceId を取得する (VS2017対応)
REM      (%2 に保存されます)
REM %1 ... VisualStudio のバージョン番号
REM %2 ... [出力] Visual Studio の InstanceId

:GetVsInstanceId
setlocal enabledelayedexpansion
set VS_VERSION=%1

set VSWHERE_VERSION_STRING=

if "%VS_VERSION%" == "15.0" (
    set VSWHERE_VERSION_STRING=[15.0,16.0^)
)

set VSWHERE_PATH="C:\Program Files (x86)\Microsoft Visual Studio\Installer\vswhere.exe"
if not exist %VSWHERE_PATH% (
    set VSWHERE_PATH="%SDK_ROOT_DIR%\Tools\Install\vswhere.exe"
)
if not exist %VSWHERE_PATH% (
    echo Not found vswhere.exe .
    endlocal
    exit /b 1
)

set INSTANCE_ID=
for /f "usebackq delims=" %%a in (`%VSWHERE_PATH% -format value -property instanceId -version !VSWHERE_VERSION_STRING! -products Microsoft.VisualStudio.Product.Professional`) do set INSTANCE_ID=%%a

if "%INSTANCE_ID%" == "" (
    echo Visual Studio v%VS_VERSION% Professional is not installed.
    endlocal
    exit /b 1
)

endlocal & (set VS_INSTANCE_ID=%INSTANCE_ID%)

exit /b 0


REM ---- レジストリハイブから値を取得する (VS2017対応)
REM      (%TARGET_REGISTRY_DATA% に保存されます)
REM %1 ... レジストリ値名
REM %2 ... VisualStudio のバージョン番号
REM %3 ... VisualStudio の instanceId

:GetRegistryDataFromHive
rem setlocal enabledelayedexpansion
set REGISTRY_VALUE=%1
set VS_VERSION=%2
set VS_INSTANCE_ID=%3

set VSREGCONFIG_PATH=%SDK_ROOT_DIR%\Tools\Install\VsRegConfig.exe

rem for /f "usebackq delims=" %%a in (`"%VSREGCONFIG_PATH%" !REGISTRY_VALUE! !VS_VERSION! !VS_INSTANCE_ID!`) do set TARGET_REGISTRY_DATA=%%a
for /f "usebackq delims=" %%a in (`"%VSREGCONFIG_PATH%" %REGISTRY_VALUE% %VS_VERSION% %VS_INSTANCE_ID%`) do set TARGET_REGISTRY_DATA=%%a

rem endlocal
exit /b 0
