@echo off

rem %1 ... SDK ルートディレクトリパス

set SDK_ROOT_DIR=%1

set APP_WIZARD_SRC_DIR=%1\Build\Vc\ForApplication\NintendoSdkApplicationCustomWizard
set LIB_WIZARD_SRC_DIR=%1\Build\Vc\ForApplication\NintendoSdkLibraryCustomWizard

set LOCALE_DIR_NAME=
call :GetLocaleDirName

REM delete old VS2012 wizard
call :DeleteWizards HKCU\Software\Microsoft\VisualStudio\11.0 VisualStudioLocation "%USERPROFILE%\Documents\Visual Studio 2012"

REM install wizard
call :DeleteTemplates HKCU\Software\Microsoft\VisualStudio\14.0 UserProjectTemplatesLocation "%USERPROFILE%\Documents\Visual Studio 2015\Templates\ProjectTemplates"
call :CopyWizards "%USERPROFILE%\Documents\Visual Studio 2015" %APP_WIZARD_SRC_DIR% %LIB_WIZARD_SRC_DIR% 14.0

REM install wizard (VS2017)
call :CopyWizards "%USERPROFILE%\Documents\Visual Studio 2017" %APP_WIZARD_SRC_DIR% %LIB_WIZARD_SRC_DIR% 15.0

exit /b


REM ---- テンプレートの削除
REM %1 ... VisualStudio のレジストリキー
REM %2 ... VisualStudio のレジストリ値名
REM %3 ... デフォルトパス

:DeleteTemplates
setlocal enabledelayedexpansion
set TARGET_REGISTORY_KEY=%1
set TARGET_REGISTORY_VALUE=%2
set DEFAULT_PATH=%3

for /F "TOKENS=1,2,*" %%A IN ('reg query "%TARGET_REGISTORY_KEY%" /reg:32 /v "%TARGET_REGISTORY_VALUE%" 2^> nul') do if "%%A"=="%TARGET_REGISTORY_VALUE%" set DEST_PATH=%%C

REM ---- %USERPROFILE%の展開処理
echo set DEST_PATH="%DEST_PATH%">temp.bat
call temp.bat
del temp.bat

if %DEST_PATH% == "" (
    set DEST_PATH=%DEFAULT_PATH%
)
set DEST_PATH=%DEST_PATH:"=%

set APP_DEST_PATH=%DEST_PATH%\NintendoSdkApplicationProjectTemplate
set LIB_DEST_PATH=%DEST_PATH%\NintendoSdkLibraryProjectTemplate

if exist "%APP_DEST_PATH%" (
    rmdir /s /q "%APP_DEST_PATH%"
)
if exist "%LIB_DEST_PATH%" (
    rmdir /s /q "%LIB_DEST_PATH%"
)

endlocal

REM --- robocopy は正常終了は 0-7
REM --- PackageManager は 0 のみを正常終了と判定するので、それのワークアラウンド
if %ERRORLEVEL% leq "7" (
    exit /b 0
)

exit /b


REM ---- ロケールディレクトリ名の取得
REM      なお、デフォルトの場合は空文字列が返ります

:GetLocaleDirName

set LOCALE_NAME=
for /F "TOKENS=1,2,*" %%A IN ('reg query "HKCU\Control Panel\International" /t REG_SZ /v "LocaleName" 2^> nul') do if "%%A"=="LocaleName" set LOCALE_NAME=%%C

if "%LOCALE_NAME%" == "ja-JP" (
    set LOCALE_DIR_NAME=
) else (
    set LOCALE_DIR_NAME=\1033
)

exit /b


REM ---- ウィザードのコピー
REM %1 ... デフォルトパス
REM %2 ... アプリケーションウィザードのコピー元
REM %3 ... ライブラリウィザードのコピー元
REM %4 ... VisualStudio のバージョン番号

:CopyWizards
setlocal enabledelayedexpansion
set DEFAULT_PATH=%1
set APP_SOURCE_PATH=%2
set LIB_SOURCE_PATH=%3
set VS_VERSION=%4

call :GetWizardDestinationDirectory %DEFAULT_PATH% %VS_VERSION%

set DEST_PATH=!WIZARD_DESTINATION_BASE_DIRECTORY!

set APP_DEST_PATH1=%DEST_PATH%\Wizards\NintendoSDK
set APP_DEST_PATH2=%DEST_PATH%\NintendoSDK\CustomWizard\NintendoSdkApplicationCustomWizard

if not exist "%APP_DEST_PATH1%" (
    mkdir "%APP_DEST_PATH1%"
)
if not exist "%APP_DEST_PATH2%" (
    mkdir "%APP_DEST_PATH2%"
)

robocopy "%APP_SOURCE_PATH%" "%APP_DEST_PATH1%" NintendoSdkApplicationCustomWizard.ico > nul
robocopy "%APP_SOURCE_PATH%%LOCALE_DIR_NAME%" "%APP_DEST_PATH1%" NintendoSdkApplicationCustomWizard.vsdir > nul
robocopy "%APP_SOURCE_PATH%" "%APP_DEST_PATH2%" /E > nul

set VSZ_SRC_PATH=%APP_SOURCE_PATH%%LOCALE_DIR_NAME%\NintendoSdkApplicationCustomWizard.vsz
set VSZ_DEST_PATH=%APP_DEST_PATH1%\NintendoSdkApplicationCustomWizard.vsz
if exist "%VSZ_DEST_PATH%" (
    del /Q "%VSZ_DEST_PATH%"
)
: パスに特殊文字が含まれた時の対策として判定文字 DELCA・DELCB を入れておいて後から除去する
set WBPATH="DELCA%APP_DEST_PATH2%DELCB"
for /f "usebackq delims= eol= " %%i in ( "%VSZ_SRC_PATH%" ) do (
    set line=%%i
    set line=!line:WIZARDBODYPATH=%WBPATH%!
    set line=!line:^"DELCA=!
    set line=!line:DELCB^"=!
    set line=!line:WIZARDVSVERSION=%VS_VERSION%!
    >> "%VSZ_DEST_PATH%" echo !line!
)

set LIB_DEST_PATH1=%DEST_PATH%\Wizards\NintendoSDK
set LIB_DEST_PATH2=%DEST_PATH%\NintendoSDK\CustomWizard\NintendoSdkLibraryCustomWizard

if not exist "%LIB_DEST_PATH1%" (
    mkdir "%LIB_DEST_PATH1%"
)
if not exist "%LIB_DEST_PATH2%" (
    mkdir "%LIB_DEST_PATH2%"
)

robocopy "%LIB_SOURCE_PATH%" "%LIB_DEST_PATH1%" NintendoSdkLibraryCustomWizard.ico > nul
robocopy "%LIB_SOURCE_PATH%%LOCALE_DIR_NAME%" "%LIB_DEST_PATH1%" NintendoSdkLibraryCustomWizard.vsdir > nul
robocopy "%LIB_SOURCE_PATH%" "%LIB_DEST_PATH2%" /E > nul

set VSZ_SRC_PATH=%LIB_SOURCE_PATH%%LOCALE_DIR_NAME%\NintendoSdkLibraryCustomWizard.vsz
set VSZ_DEST_PATH=%LIB_DEST_PATH1%\NintendoSdkLibraryCustomWizard.vsz
if exist "%VSZ_DEST_PATH%" (
    del /Q "%VSZ_DEST_PATH%"
)
: パスに特殊文字が含まれた時の対策として判定文字 DELCA・DELCB を入れておいて後から除去する
set WBPATH="DELCA%LIB_DEST_PATH2%DELCB"
for /f "usebackq delims= eol= " %%i in ( "%VSZ_SRC_PATH%" ) do (
    set line=%%i
    set line=!line:WIZARDBODYPATH=%WBPATH%!
    set line=!line:^"DELCA=!
    set line=!line:DELCB^"=!
    set line=!line:WIZARDVSVERSION=%VS_VERSION%!
    >> "%VSZ_DEST_PATH%" echo !line!
)


REM --- robocopy は正常終了は 0-7
REM --- PackageManager は 0 のみを正常終了と判定するので、それのワークアラウンド
if %ERRORLEVEL% leq 7 (
    exit /b 0
)

endlocal

exit /b


REM ---- ウィザードの削除
REM %1 ... VisualStudio のレジストリキー
REM %2 ... VisualStudio のレジストリ値名
REM %3 ... デフォルトパス

:DeleteWizards
setlocal
set TARGET_REGISTORY_KEY=%1
set TARGET_REGISTORY_VALUE=%2
set DEFAULT_PATH=%3

for /F "TOKENS=1,2,*" %%A IN ('reg query "%TARGET_REGISTORY_KEY%" /reg:32 /v "%TARGET_REGISTORY_VALUE%"') do if "%%A"=="%TARGET_REGISTORY_VALUE%" set DEST_PATH=%%C

REM ---- %USERPROFILE%の展開処理
echo set DEST_PATH="%DEST_PATH%">temp.bat
call temp.bat
del temp.bat

if %DEST_PATH% == "" (
    set DEST_PATH=%DEFAULT_PATH%
)
set DEST_PATH=%DEST_PATH:"=%

set WIZARD_CONFIG_PATH=%DEST_PATH%\Wizards\NintendoSDK

if exist "%WIZARD_CONFIG_PATH%" (
    rmdir /s /q "%WIZARD_CONFIG_PATH%"
)

set APP_DEST_PATH=%DEST_PATH%\NintendoSDK\CustomWizard\NintendoSdkApplicationCustomWizard

if exist "%APP_DEST_PATH%" (
    rmdir /s /q "%APP_DEST_PATH%"
)

set LIB_DEST_PATH=%DEST_PATH%\NintendoSDK\CustomWizard\NintendoSdkLibraryCustomWizard

if exist "%LIB_DEST_PATH%" (
    rmdir /s /q "%LIB_DEST_PATH%"
)

endlocal

exit /b


REM ---- ウィザードのコピー先ディレクトリの取得
REM      (%WIZARD_DESTINATION_BASE_DIRECTORY% に保存されます)
REM %1 ... 取得できなかった場合のデフォルトパス
REM %2 ... VisualStudio のバージョン番号

:GetWizardDestinationDirectory
setlocal enabledelayedexpansion
set DEFAULT_PATH=%1
set VS_VERSION=%2

set WIZARD_DESTINATION_BASE_DIRECTORY=

rem set TARGET_REGISTORY_KEY=
rem set TARGET_REGISTORY_VALUE=VisualStudioLocation
set TARGET_REGISTRY_DATA=
set VS_INSTANCE_ID=

if "%VS_VERSION%"=="14.0" (
    call :GetRegistryData HKCU\Software\Microsoft\VisualStudio\14.0 VisualStudioLocation
) else if "%VS_VERSION%"=="15.0" (
    call :GetVsInstanceId 15.0
    call :GetRegistryDataFromHive VisualStudioLocation 15.0 !VS_INSTANCE_ID!
) else (
    endlocal
    exit /b 1
)

REM ---- %USERPROFILE%の展開処理
echo set TARGET_REGISTRY_DATA="%TARGET_REGISTRY_DATA%">temp.bat
call temp.bat
del temp.bat

set WIZARD_DESTINATION_BASE_DIRECTORY=%TARGET_REGISTRY_DATA%

if %WIZARD_DESTINATION_BASE_DIRECTORY% == "" (
    set WIZARD_DESTINATION_BASE_DIRECTORY=%DEFAULT_PATH%
)
set WIZARD_DESTINATION_BASE_DIRECTORY=%WIZARD_DESTINATION_BASE_DIRECTORY:"=%

endlocal & (set WIZARD_DESTINATION_BASE_DIRECTORY=%WIZARD_DESTINATION_BASE_DIRECTORY%)

exit /b 0


REM ---- レジストリから値を取得する
REM      (%TARGET_REGISTRY_DATA% に保存されます)
REM %1 ... レジストリキー
REM %2 ... レジストリ値名

:GetRegistryData
set REGISTRY_KEY=%1
set REGISTRY_VALUE=%2

set TARGET_REGISTRY_DATA=
for /F "TOKENS=1,2,*" %%A IN ('reg query "%REGISTRY_KEY%" /reg:32 /v "%REGISTRY_VALUE%" 2^> nul') do if "%%A"=="%REGISTRY_VALUE%" set TARGET_REGISTRY_DATA=%%C

exit /b 0


REM ---- Visual Studio の InstanceId を取得する (VS2017対応)
REM      (%2 に保存されます)
REM %1 ... VisualStudio のバージョン番号
REM %2 ... [出力] Visual Studio の InstanceId

:GetVsInstanceId
setlocal enabledelayedexpansion
set VS_VERSION=%1

set VSWHERE_VERSION_STRING=

if "%VS_VERSION%" == "15.0" (
    set VSWHERE_VERSION_STRING=[15.0,16.0^)
)

set VSWHERE_PATH="C:\Program Files (x86)\Microsoft Visual Studio\Installer\vswhere.exe"
if not exist %VSWHERE_PATH% (
    set VSWHERE_PATH="%SDK_ROOT_DIR%\Tools\Install\vswhere.exe"
)
if not exist %VSWHERE_PATH% (
    echo Not found vswhere.exe .
    endlocal
    exit /b 1
)

set INSTANCE_ID=
for /f "usebackq delims=" %%a in (`%VSWHERE_PATH% -format value -property instanceId -version !VSWHERE_VERSION_STRING! -products Microsoft.VisualStudio.Product.Professional`) do set INSTANCE_ID=%%a

if "%INSTANCE_ID%" == "" (
    echo Visual Studio v%VS_VERSION% Professional is not installed.
    endlocal
    exit /b 1
)

endlocal & (set VS_INSTANCE_ID=%INSTANCE_ID%)

exit /b 0


REM ---- レジストリハイブから値を取得する (VS2017対応)
REM      (%TARGET_REGISTRY_DATA% に保存されます)
REM %1 ... レジストリ値名
REM %2 ... VisualStudio のバージョン番号
REM %3 ... VisualStudio の instanceId

:GetRegistryDataFromHive
rem setlocal enabledelayedexpansion
set REGISTRY_VALUE=%1
set VS_VERSION=%2
set VS_INSTANCE_ID=%3

set VSREGCONFIG_PATH=%SDK_ROOT_DIR%\Tools\Install\VsRegConfig.exe

rem for /f "usebackq delims=" %%a in (`"%VSREGCONFIG_PATH%" !REGISTRY_VALUE! !VS_VERSION! !VS_INSTANCE_ID!`) do set TARGET_REGISTRY_DATA=%%a
for /f "usebackq delims=" %%a in (`"%VSREGCONFIG_PATH%" %REGISTRY_VALUE% %VS_VERSION% %VS_INSTANCE_ID%`) do set TARGET_REGISTRY_DATA=%%a

rem endlocal
exit /b 0
