﻿/*
 *  Copyright 2005-2014 Acer Cloud Technology, Inc.
 *  All Rights Reserved.
 *
 *  This software contains confidential information and
 *  trade secrets of Acer Cloud Technology, Inc.
 *  Use, disclosure or reproduction is prohibited without
 *  the prior express written permission of Acer Cloud
 *  Technology, Inc.
 */

/*
 *               Copyright (C) 2010, BroadOn Communications Corp.
 *
 *  These coded instructions, statements, and computer programs contain
 *  unpublished  proprietary information of BroadOn Communications Corp.,
 *  and  are protected by Federal copyright law. They may not be disclosed
 *  to  third  parties or copied or duplicated in any form, in whole or in
 *  part, without the prior written consent of BroadOn Communications Corp.
 *
 */

#include "es_utils.h"
#include <nn/iosc/iosc.h>
#include <nn/escore/escore.h>

USING_ES_NAMESPACE
USING_ISTORAGE_NAMESPACE

#include "es_container.h"
#include "es_device.h"
#include "es_storage.h"


ES_NAMESPACE_START


ETicketService::ETicketService()
{
    IOSC_Initialize();
}


ETicketService::~ETicketService()
{
}

ESError
ETicketService::Sign(ESTitleId signerTitleId,
                     IInputStream &data, u32 dataSize,
                     void *outSig, u32 outSigSize,
                     void *outCert, u32 outCertSize)
{
    return esSign(signerTitleId, data, dataSize, outSig, outSigSize, outCert, outCertSize);
}


ESError
ETicketService::VerifySign(ESTitleId signerTitleId,
                           ISTORAGE_SYM(IInputStream) &data, u32 dataSize,
                           const void *sig, u32 sigSize, ESSigType sigType,
                           const void *certs[], u32 nCerts)
{
    return esVerifySign(signerTitleId, data, dataSize, sig, sigSize, sigType, certs, nCerts);
}


ESError
ETicketService::VerifyCerts(const void *certs[], u32 nCerts,
                            const void *verifyChain[], u32 nChainCerts)
{
    return esVerifyCerts(certs, nCerts, verifyChain, nChainCerts);
}


ESError
ETicketService::GetDeviceCert(void *outDeviceCert, u32 outDeviceCertSize)
{
    return esGetDeviceCert(outDeviceCert, outDeviceCertSize);
}

ESError
ETicketService::SetDeviceCert(const void *inDeviceCert, u32 inDeviceCertSize )
{
    return esSetDeviceCert( inDeviceCert, inDeviceCertSize );
}

ESError
ETicketService::SetDevicePrivateKey(const void *inDevicePrivateKey, u32 inDevicePrivateKeySize )
{
    return esSetDevicePrivateKey( inDevicePrivateKey, inDevicePrivateKeySize );
}

ESError
ETicketService::GetDeviceId(ESDeviceId *outDeviceId)
{
    return esGetDeviceId(outDeviceId);
}


Result
ETicketService::GetLastSystemResult()
{
    return esGetLastSystemResult();
}

ES_NAMESPACE_END
