﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nn/csl/sha256.h>
#include <nn/crypto/crypto_Sha256Generator.h>

int
SHA256Reset(SHA256Context* ctx)
{
    nn::crypto::Sha256Generator sha256Generator;
    sha256Generator.Initialize();
    sha256Generator.GetContext((nn::crypto::Sha256Context*)ctx);
    memset(ctx->data, 0, sizeof(SHA256Context) - sizeof(nn::crypto::Sha256Context));

    return 0;
}

int
SHA256Input(SHA256Context* ctx, const u8 *buf, int len)
{
    nn::crypto::Sha256Generator sha256Generator;
    sha256Generator.InitializeWithContext((nn::crypto::Sha256Context*)ctx);
    if (ctx->num != 0)
    {
        sha256Generator.Update(ctx->data, ctx->num);
    }

    sha256Generator.Update(buf, len);
    ctx->num = (u32)sha256Generator.GetContext((nn::crypto::Sha256Context*)ctx);
    if (ctx->num != 0)
    {
        sha256Generator.GetBufferedData(ctx->data, nn::crypto::Sha256Generator::BlockSize);
    }

    return 0;
}

int
SHA256Result(SHA256Context* ctx, u8 digest[SHA256_DIGESTSIZE])
{
    nn::crypto::Sha256Generator sha256Generator;
    sha256Generator.InitializeWithContext((nn::crypto::Sha256Context*)ctx);
    if (ctx->num != 0)
    {
        sha256Generator.Update(ctx->data, ctx->num);
    }
    sha256Generator.GetHash(digest, nn::crypto::Sha256Generator::HashSize);

    return 0;
}
