﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <new>
#include <nn/csl/sha1.h>
#include <nn/crypto/crypto_Sha1Generator.h>

int
SHA1Reset(SHA1Context* ctx)
{
    nn::crypto::Sha1Generator *sha1Generator = ::new(ctx) nn::crypto::Sha1Generator;
    sha1Generator->Initialize();

    return 0;
}

int
SHA1Input(SHA1Context* ctx, const SHA1_BYTE *buf, int len)
{
    ((nn::crypto::Sha1Generator*)ctx)->Update(buf, len);

    return 0;
}

int SHA1Result(SHA1Context* ctx, SHA1_BYTE digest[SHA1_DIGESTSIZE])
{
    ((nn::crypto::Sha1Generator*)ctx)->GetHash(digest, SHA1_DIGESTSIZE);

    return 0;
}
