﻿/*
 *  Copyright 2005-2014 Acer Cloud Technology, Inc.
 *  All Rights Reserved.
 *
 *  This software contains confidential information and
 *  trade secrets of Acer Cloud Technology, Inc.
 *  Use, disclosure or reproduction is prohibited without
 *  the prior express written permission of Acer Cloud
 *  Technology, Inc.
 */

/*
 *               Copyright (C) 2005, BroadOn Communications Corp.
 *
 *  These coded instructions, statements, and computer programs contain
 *  unpublished  proprietary information of BroadOn Communications Corp.,
 *  and  are protected by Federal copyright law. They may not be disclosed
 *  to  third  parties or copied or duplicated in any form, in whole or in
 *  part, without the prior written consent of BroadOn Communications Corp.
 *
 */
#if defined(SC)
#include <ioslibc.h>
#elif defined(RVL)
#include <ioslibc.h>
#else
#include <string.h>
#endif

#include <nn/csl/cslsha.h>
#include <nn/csl/csl.h>

#define IPAD 0x36
#define OPAD 0x5c


/* H(K xor opad, H(K xor ipad, text)) */
int
CSL_ResetHmac(CSL_HmacContext *context, CSLOSHMACKey key)
{
    u8 kxorpad[CSL_SHA1_BLOCKSIZE];
    u8 kext[CSL_SHA1_BLOCKSIZE];
    int i;

    memcpy(kext, key, sizeof(CSLOSHMACKey));
    memset(kext + sizeof(CSLOSHMACKey), 0x0,
           sizeof(kext) - sizeof(CSLOSHMACKey));
    memcpy(context->keyExt, kext, CSL_SHA1_BLOCKSIZE);
    for (i = 0; i < CSL_SHA1_BLOCKSIZE; i++) {
        kxorpad[i] = kext[i] ^ IPAD;
    }
    CSL_ResetSha(&(context->context));
    CSL_InputSha(&(context->context), (SHA1_BYTE *) kxorpad, CSL_SHA1_BLOCKSIZE);
    return CSL_OK;
}

int
CSL_InputHmac(CSL_HmacContext *context, u8 *inputData, u32 inputSize)
{
    CSL_InputSha(&(context->context), inputData, inputSize);
    return CSL_OK;
}


int
CSL_ResultHmac(CSL_HmacContext *context, CSLOSSha1Hash hmac)
{
    u8 kxorpad[CSL_SHA1_BLOCKSIZE];
    u8 hashData[CSL_SHA1_DIGESTSIZE];
    int i;
    CSL_ResultSha(&(context->context), hashData);
    /* second hash */
    for (i = 0; i < CSL_SHA1_BLOCKSIZE; i++) {
        kxorpad[i] = context->keyExt[i] ^ OPAD;
    }
    CSL_ResetSha(&(context->context));
    CSL_InputSha(&(context->context), kxorpad, CSL_SHA1_BLOCKSIZE);
    CSL_InputSha(&(context->context), hashData, CSL_SHA1_DIGESTSIZE);
    CSL_ResultSha(&(context->context), hmac);
    return CSL_OK;
}
