﻿/*
 *  Copyright 2005-2014 Acer Cloud Technology, Inc.
 *  All Rights Reserved.
 *
 *  This software contains confidential information and
 *  trade secrets of Acer Cloud Technology, Inc.
 *  Use, disclosure or reproduction is prohibited without
 *  the prior express written permission of Acer Cloud
 *  Technology, Inc.
 */

/*
 *  Copyright 2011 iGware, Inc.
 *  All Rights Reserved.
 *
 *  This software contains confidential information and
 *  trade secrets of iGware, Inc.
 *  Use, disclosure or reproduction is prohibited without
 *  the prior express written permission of iGware, Inc.
 */

/*
 *               Copyright (C) 2010, BroadOn Communications Corp.
 *
 *  These coded instructions, statements, and computer programs contain
 *  unpublished  proprietary information of BroadOn Communications Corp.,
 *  and  are protected by Federal copyright law. They may not be disclosed
 *  to  third  parties or copied or duplicated in any form, in whole or in
 *  part, without the prior written consent of BroadOn Communications Corp.
 *
 */


#ifndef __ES_H__
#define __ES_H__


#if defined(NN_PLATFORM_CTR) && !defined(IGWARE_ETD_BUILD)
#include <nn/drivers/es/CTR/estypes.h>
#include <nn/drivers/es/CTR/istorage.h>
#else
#include <nn/escore/estypes.h>
#include <nn/istorage/istorage.h>
#endif


/*
 * Storage objects are used in the following three cases:
 *  1) Ticket and TMD (i.e. large data structures)
 *  2) Data for signing and verification (i.e. size depends on user input)
 *  3) Checkpointing the import/export context to non-volatile storage
 */

ES_NAMESPACE_START

class ETicket
{
    public:
        // Initialization and shutdown
        ETicket();
        ~ETicket();

        ESError Set(ISTORAGE_SYM(IInputStream) &ticket,
                    const void *certs[], u32 nCerts, bool doVerify);

        // Ticket information
        ESError GetSize(u32 *outSize);
        ESError GetTitleKeyType( ESTitleKeyType *outTitleKeyType );
        ESError GetTitleKey( ESTitleKey *outTitleKey );
        ESError GetTicketId(ESTicketId *outTicketId);
        ESError GetTicketVersion(ESTicketVersion *outTicketVersion);
        ESError GetRightsId(ESRightsId *outRightsId);
        ESError GetDeviceId(ESDeviceId *outDeviceId);
        ESError GetAccountId(ESAccountId *outAccountId);
        ESError GetPreInstallationFlag(bool *outFlag);
        ESError GetLicenseType(ESLicenseType *outLicenseType);
        ESError GetIssuerName(u8 *outIssuer);
        ESError GetCommonKeyId(u8 *outCommonKeyId);
        ESError GetPropertyMask(u16 *outPropertyMask);

        // Result of the last system operation
        Result GetLastSystemResult();
};


class Certificate
{
    public:
        // Initialization and shutdown
        Certificate();
        ~Certificate();

        // Parse and merge certificate list
        ESError GetNumCertsInList(const void *certList, u32 certListSize,
                                  u32 *outNumCerts);
        ESError ParseCertList(const void *certList, u32 certListSize,
                              void *outCerts[], u32 *outCertSizes,
                              u32 *outNumCerts);
        ESError MergeCerts(const void *certs1[], u32 nCerts1,
                           const void *certs2[], u32 nCerts2,
                           void *outCerts[], u32 *outCertSizes,
                           u32 *outNumCerts);
        ESError GetCertSize( const void *cert, u32 *certSize );
        ESError GetCertNames( const void *cert, u8 **issuerName, u8 **subjectName );
};


class ETicketService
{
    public:
        // Initialization and shutdown
        ETicketService();
        ~ETicketService();

        // Operations
        ESError Sign(ESTitleId signerTitleId, ISTORAGE_SYM(IInputStream) &data,
                     u32 dataSize, void *outSig, u32 outSigSize,
                     void *outCert, u32 outCertSize);
        ESError VerifySign(ESTitleId signerTitleId,
                           ISTORAGE_SYM(IInputStream) &data, u32 dataSize,
                           const void *sig, u32 sigSize, ESSigType sigType,
                           const void *certs[], u32 nCerts);
        ESError VerifyCerts(const void *certs[], u32 nCerts,
                            const void *verifyChain[], u32 nChainCerts);

        ESError GetDeviceCert(void *outDeviceCert, u32 outDeviceCertSize);
        ESError SetDeviceCert(const void *inDeviceCert, u32 outDeviceCertSize );
        ESError SetDevicePrivateKey(const void *inDevicePrivateKey, u32 inDevicePrivateKeySize );
        ESError GetDeviceId(ESDeviceId *outDevId);

        // Result of the last system operation
        Result GetLastSystemResult();
};

ES_NAMESPACE_END

#endif  // __ES_H__
