﻿// 文字コード:UTF-8
/// @file
#include "sys/account/Account.hpp"

#include <nn/account/account_Api.h>
#include <nn/account/account_ApiForApplications.h>

//------------------------------------------------------------------------------
namespace sys {
namespace account {
//------------------------------------------------------------------------------
Account::Account()
    : mUserCount()
{
    ::nn::account::Initialize();
    auto result = ::nn::account::GetUserCount(&mUserCount);
    SYS_ASSERT(result.IsSuccess());
    SetInstance(this);
}

//------------------------------------------------------------------------------
Account::~Account()
{
    UnsetInstance();
}

//------------------------------------------------------------------------------
::nn::account::Uid Account::toUid(int aIndex)
{
    if (aIndex < 0 || aIndex >= mUserCount) {
        return nn::account::InvalidUid;
    }

    int actualLength = 0;
    ::nn::account::Uid uidArray[mUserCount];
    auto result = ::nn::account::ListAllUsers(&actualLength, uidArray, mUserCount);
    SYS_ASSERT(result.IsSuccess());
    SYS_ASSERT(actualLength == mUserCount);
    return uidArray[aIndex];
}

//------------------------------------------------------------------------------
}
}
//------------------------------------------------------------------------------
// EOF
