﻿// 文字コード:UTF-8
/// @file
#pragma once

#include <cstdlib>

#include <nn/init.h>
#include <nn/nn_Assert.h>
#include <nn/nn_Abort.h>
#include <nn/nn_Common.h>
#include <nn/nn_Log.h>
#include <nn/nn_Result.h>
#include <nn/oe.h>
#include <nn/os.h>
#include <nn/mem.h>

#if defined(USE_DEBUG_UTIL)
#define  DEBUG_IS_ENABLED 1
#else
#define  DEBUG_IS_ENABLED 0
#endif

#if DEBUG_IS_ENABLED
#define DEBUG_LOG NN_LOG
#define DEBUG_EVAL(CODE) CODE
#else
#define DEBUG_LOG
#define DEBUG_EVAL(CODE)
#endif

#define PLATFORM_IS_NX 1
#define COMPILER_IS_CLANG 1

#include "Assert.hpp"
#include "lib/Array.hpp"
#include "lib/Function.hpp"
#include "lib/ForwardDeclare.hpp"
#include "lib/Math.hpp"
#include "lib/MutableArray.hpp"
#include "lib/NonCopyable.hpp"
#include "lib/NonCreatable.hpp"
#include "lib/Pointer.hpp"
#include "lib/ScopedPtr.hpp"
#include "lib/ShortString.hpp"
#include "lib/String.hpp"
#include "lib/U16String.hpp"
#include "lib/Vector2.hpp"
#include "lib/Vector2i.hpp"
#include "lib/Type.hpp"

#include "ErrorLogger.hpp"

#define U16(X) reinterpret_cast<const uint16_t*>(u##X)

#define WEBCALLERCOMMAND_NAME "WebCallerCommand"

//-----------------------------------------------------------------------------
// EOF
