﻿// 文字コード:UTF-8
/// @file
#pragma once

#include <lib/logger/ILoggerHandler.hpp>

//------------------------------------------------------------------------------
namespace lib {
namespace logger {

//------------------------------------------------------------------------------
/// @addtogroup LIB-Logger
//@{
/// 単純なLoggerHandler。printfで出力する。
class SimpleLoggerHandler
    : public ILoggerHandler
{
public:
    /// @name インスタンス
    //@{
    static SimpleLoggerHandler& Instance(); ///< インスタンスの取得。
    //@}

    /// @name ILoggerHandlerの実装
    //@{
    virtual void onLogWritten(
        const Logger& aLogger,
        LogLevel::EnumType aLevel,
        const char* aMsg,
        ILoggerHandler::TimeType aTime
        );
    //@}
};
//@}
}} // namespace
// EOF
