﻿// 文字コード:UTF-8
/// @file
#include <lib/logger/LogLevelUtil.hpp>

#include <lib/debug/Assert.hpp>

//------------------------------------------------------------------------------
namespace lib {
namespace logger {

//------------------------------------------------------------------------------
bool LogLevelUtil::IsValid(const LogLevel::EnumType aLevel)
{
    return 0 <= aLevel && aLevel < LogLevel::TERM;
}

//------------------------------------------------------------------------------
bool LogLevelUtil::IsReceiveLog(
    const LogLevel::EnumType aMessageLevel,
    const LogLevel::EnumType aLoggerLevel
    )
{
    SYS_ASSERT(IsValid(aMessageLevel));
    SYS_ASSERT(IsValid(aLoggerLevel));
    return aLoggerLevel <= aMessageLevel;
}

//------------------------------------------------------------------------------
const char* LogLevelUtil::ToCString(const LogLevel::EnumType aLevel)
{
    const char* LABELS[]=
    {
        "Debug",
        "Trace",
        "Info",
        "Warn",
        "Error"
    };
    SYS_ASSERT_ARRAY_NUM(LABELS , LogLevel::TERM);

    SYS_ASSERT(IsValid(aLevel));
    return LABELS[aLevel];
}

}} // namespace
// EOF
