﻿// 文字コード:UTF-8
/// @file
#pragma once

#include <lib/logger/LogLevel.hpp>

namespace lib {
namespace logger {
    class Logger;
}}

//------------------------------------------------------------------------------
namespace lib {
namespace logger {

/// @addtogroup LIB-Logger
//@{
/// Loggerのハンドラークラス。
class ILoggerHandler
{
public:
    /// @name 型定義
    //@{
    /// 時間を示す型。
    typedef int TimeType;
    //@}

    /// @name コンストラクタとデストラクタ
    //@{
    virtual ~ILoggerHandler() {} ///< デストラクタ。
    //@}

    /// @name API
    //@{
    /// ログが書き込まれた瞬間に呼ばれる。
    /// @param aSender これを呼び出したオブジェクト。
    /// @param aLevel ログのレベル。
    /// @param aMessage ログのメッセージ。
    /// @param aTime ログが書き込まれた時間。
    virtual void onLogWritten(
        const Logger& aSender,
        LogLevel::EnumType aLevel,
        const char* aMessage,
        TimeType aTime
        ) = 0;
    //@}
};
//@}

}} // namespace
// EOF
