﻿// 文字コード:UTF-8
/// @file
#include <lib/debug/Assert.hpp>
#include <lib/Unused.hpp>
#include <lib/Vector3.hpp>

//------------------------------------------------------------------------------
namespace lib {
namespace debug {
const char* const Assert::MessagePanic
    = "LIB Panic Called.";
const char* const Assert::MessageAssertDefault
    = "Assertion failed.";
const char* const Assert::MessageAssertNotReach
    = "Should not reach here.";
const char* const Assert::MessageAssertPointer
    = "Pointer Assertion failed.";
// 可読性のため「文字列連結」を使っています
const char* const Assert::FormatAssert1
    = "LIB_ASSERT1 failed.\n" "%s\n";
const char* const Assert::FormatAssert2
    = "LIB_ASSERT2 failed.\n" "%s\n" "%s\n";
const char* const Assert::FormatAssert3
    = "LIB_ASSERT3 failed.\n" "%s\n" "%s\n" "%s\n";
const char* const Assert::FormatAssertEqual
    = "LIB_ASSERT_EQUAL failed.\n" "aValue1 : %s\n" "aValue2 : %s\n";
const char* const Assert::FormatAssertNotEqual
    = "LIB_ASSERT_NOT_EQUAL failed.\n" "aValue1 : %s\n" "aValue2 : %s\n";
const char* const Assert::FormatAssertLess
    = "LIB_ASSERT_LESS failed.\n" "aValue1 : %s\n" "aValue2 : %s\n";
const char* const Assert::FormatAssertLessEqual
    = "LIB_ASSERT_LESS_EQUAL failed.\n" "aValue1 : %s\n" "aValue2 : %s\n";
const char* const Assert::FormatAssertGreater
    = "LIB_ASSERT_GREATER failed.\n" "aValue1 : %s\n" "aValue2 : %s\n";
const char* const Assert::FormatAssertGreaterEqual
    = "LIB_ASSERT_GREATER_EQUAL failed.\n" "aValue1 : %s\n" "aValue2 : %s\n";
const char* const Assert::FormatAssertMinMax
    = "LIB_ASSERT_MIN_MAX failed.\n" "aValue : %s\n" "aMin : %s\n" "aMax : %s\n";
const char* const Assert::FormatAssertMinTerm
    = "LIB_ASSERT_MIN_TERM failed.\n" "aValue : %s\n" "aMin : %s\n" "aTerm : %s\n";
const char* const Assert::FormatAssertEnum
    = "LIB_ASSERT_ENUM failed.\n" "aValue : %s\n" "aMin : %s\n" "TERM : %s\n";

//------------------------------------------------------------------------------
bool Assert::IsPointerValid(const void* aPointer)
{
    return aPointer != 0;
}

}} // namespace
// EOF
