﻿// 文字コード:UTF-8
/// @file
#pragma once

#include <lib/Math.hpp>
#include <lib/Vector3Pod.hpp>
#include <lib/debug/Assert.hpp>
#include <lib/ShortString.hpp>

//------------------------------------------------------------------------------
namespace lib {

/// @addtogroup LIB-Math
//@{
/// ３次元ベクトルのクラス版。
class Vector3
    : public Vector3Pod
{
public:
    /// @name 基本メソッド
    //@{
    /// デフォルトコンストラクタ。
    inline Vector3();
    /// コンストラクタ：成分指定。
    inline Vector3(float aX, float aY, float aZ);
    /// コンストラクタ：Vector3Pod型。
    inline Vector3(const Vector3Pod& aVec);
    /// コンストラクタ：Vector2Pod型とZ値。
    inline Vector3(const Vector2Pod& aVector2, float aZ);
    //@}
};
//@}

//------------------------------------------------------------------------------
Vector3::Vector3()
{
    x = y = z = 0.0f;
}

//------------------------------------------------------------------------------
Vector3::Vector3(const float aX, const float aY, const float aZ)
{
    this->x = aX;
    this->y = aY;
    this->z = aZ;
}

//------------------------------------------------------------------------------
Vector3::Vector3(const Vector3Pod& aVec)
{
    this->x = aVec.x;
    this->y = aVec.y;
    this->z = aVec.z;
}

//------------------------------------------------------------------------------
Vector3::Vector3(const Vector2Pod& aVector2, const float aZ)
{
    this->x = aVector2.x;
    this->y = aVector2.y;
    this->z = aZ;
}

} // namespace
// EOF
