﻿// 文字コード:UTF-8
/// @file
#include "lib/U16CString.hpp"

#include <cstring>
#include "lib/Math.hpp"
#include "lib/StringConvert.hpp"

namespace lib {

const char16_t U16CString::EMPTY[] = { 0x0000 };
//------------------------------------------------------------------------------
int32_t U16CString::GetLength(const char16_t* aStr)
{
    int32_t len = 0;
    while (1) {
        if (aStr[len] == 0) {
            break;
        }
        len++;
    }
    return(len);
}

//------------------------------------------------------------------------------
void U16CString::Catenate(char16_t* aStr, const char16_t* aAdditionalStr)
{
    int32_t len = GetLength(aStr);
    int32_t additionalLen = GetLength(aAdditionalStr);
    for (int32_t i = 0; i < additionalLen; ++i) {
        aStr[len + i] = aAdditionalStr[i];
    }
    aStr[len + additionalLen] = 0;
}

//------------------------------------------------------------------------------
void U16CString::Copy(char16_t* aDst, const char16_t* aSrc, uint32_t aCap)
{
    bool allCopied = CopyAsPossible(aDst, aSrc, aCap);
    SYS_ASSERT(allCopied);
}

//------------------------------------------------------------------------------
bool U16CString::CopyAsPossible(char16_t* aDst, const char16_t* aSrc, uint32_t aCap)
{
    SYS_ASSERT_POINTER(aDst);
    SYS_ASSERT_POINTER(aSrc);
    SYS_ASSERT(0 < aCap);
    uint32_t reqCap = GetLength(aSrc) + 1;
    uint32_t copyLen = Math::Min(aCap, reqCap);
    ::std::memcpy(aDst, aSrc, sizeof(char16_t) * copyLen);
    aDst[aCap - 1] = 0;
    return reqCap <= aCap;
}

//------------------------------------------------------------------------------
void U16CString::Format(char16_t* aStr, int aCap, const char16_t* aFmt, ...)
{
    ::std::va_list vaList = {};
    va_start(vaList, aFmt);
    FormatV(aStr, aCap, aFmt, vaList);
    va_end(vaList);
}

//------------------------------------------------------------------------------
void U16CString::FormatV(char16_t* aStr, int aCap, const char16_t* aFmt, ::std::va_list aVaList)
{
    auto format = ::lib::String::FromUtf16(aFmt);
    auto string = ::lib::String::FromFormatV(aCap, format.buffer(), aVaList);
    StringConvert::ConvertUtf8ToUtf16(aStr, aCap, string.buffer());
}

//------------------------------------------------------------------------------
void U16CString::FormatAsPossible(char16_t* aStr, int aCap, const char16_t* aFmt, ...)
{
    ::std::va_list vaList = {};
    va_start(vaList, aFmt);
    FormatVAsPossible(aStr, aCap, aFmt, vaList);
    va_end(vaList);
}

//------------------------------------------------------------------------------
void U16CString::FormatVAsPossible(char16_t* aStr, int aCap, const char16_t* aFmt, ::std::va_list aVaList)
{
    auto format = ::lib::String::FromUtf16(aFmt);
    auto string = ::lib::String::FromFormatVAsPossible(aCap, format.buffer(), aVaList);
    StringConvert::ConvertUtf8ToUtf16(aStr, aCap, string.buffer());
}

} // namespace
// EOF
