﻿// 文字コード:UTF-8
/// @file
#pragma once

//------------------------------------------------------------------------------
namespace lib {
/// コンパイル時にTTypeがunsignedを含む型か？を判定するトレイツ（特性）。
/// @details
/// C++11ではstd:is_unsigned (in type_traits)として定義されているのと同様のもの。
/// * 使い方
/// @code
/// // ある型Typeが、unsignedを含む型か？をコンパイル時にチェックしたい。
/// LIB_COMPILER_ASSERT(TypeTraitsIsUnsigned<Type>::Value);
/// @endcode
/// * 実装メモ
/// テンプレートのデフォルト(一般の定義)ではValueをfalseとしておき、
/// unsignedな型はテンプレート特殊化でValueをtrueと定義する。
/// テンプレートを特殊化するものが多いので、可読性のために、
/// LIBのコーディングルールに反した書き方をしている。
template<typename TType> struct TypeTraitsIsUnsigned
{
    // LIBのenumのコーディングルールに違反しているが、enumであることは
    // 本質的ではなく、コンパイル時に定数であることを表現したいためだけなので
    // このようにしている。
    enum
    {
        // このValueの値が結果。値はtrueかfalse。
        // デフォルトの定義はfalse。
        Value = false
    };
};

// 以下、unsignedな型についての特殊化群。Valueがtrueとなる。
template<> struct TypeTraitsIsUnsigned<unsigned char> { enum { Value = true }; };
template<> struct TypeTraitsIsUnsigned<const unsigned char> { enum { Value = true }; };
template<> struct TypeTraitsIsUnsigned<volatile unsigned char> { enum { Value = true }; };
template<> struct TypeTraitsIsUnsigned<const volatile unsigned char> { enum { Value = true }; };
template<> struct TypeTraitsIsUnsigned<unsigned short> { enum { Value = true }; };
template<> struct TypeTraitsIsUnsigned<const unsigned short> { enum { Value = true }; };
template<> struct TypeTraitsIsUnsigned<volatile unsigned short> { enum { Value = true }; };
template<> struct TypeTraitsIsUnsigned<const volatile unsigned short> { enum { Value = true }; };
template<> struct TypeTraitsIsUnsigned<unsigned int> { enum { Value = true }; };
template<> struct TypeTraitsIsUnsigned<const unsigned int> { enum { Value = true }; };
template<> struct TypeTraitsIsUnsigned<volatile unsigned int> { enum { Value = true }; };
template<> struct TypeTraitsIsUnsigned<const volatile unsigned int> { enum { Value = true }; };
template<> struct TypeTraitsIsUnsigned<unsigned long> { enum { Value = true }; };
template<> struct TypeTraitsIsUnsigned<const unsigned long> { enum { Value = true }; };
template<> struct TypeTraitsIsUnsigned<volatile unsigned long> { enum { Value = true }; };
template<> struct TypeTraitsIsUnsigned<const volatile unsigned long> { enum { Value = true }; };
template<> struct TypeTraitsIsUnsigned<unsigned long long> { enum { Value = true }; };
template<> struct TypeTraitsIsUnsigned<const unsigned long long> { enum { Value = true }; };
template<> struct TypeTraitsIsUnsigned<volatile unsigned long long> { enum { Value = true }; };
template<> struct TypeTraitsIsUnsigned<const volatile unsigned long long> { enum { Value = true }; };

} // namespace
// EOF
