﻿// 文字コード:UTF-8
/// @file
#pragma once

//------------------------------------------------------------------------------
namespace lib {

/// タイマー、指定フレーム待機とコールバック、レート取得など
class Timer
{
public:
    Timer();
    /// 開始
    void start(int aFrameLen, const ::lib::Function<void()>& aFinishedCallback = ::lib::Function<void()>());
    /// 稼働中でないなら開始する
    void startIfNotRunning(int aFrameLen, const ::lib::Function<void()>& aFinishedCallback = ::lib::Function<void()>());
    /// 開始するが絶対に終了しない
    void startInfinitely();
    /// 現在のフレーム取得
    int getFrame() const { return mFrame; }
    /// 残りフレーム取得
    int getRestFrame() const { return ((mFrameLen - mFrame) < 0) ? 0 : mFrameLen-mFrame; }
    /// 総フレーム数取得
    int getFrameSize() const { return mFrameLen; }
    /// 進行具合を0.0から1.0の範囲で取得する
    float getRatio() const;
    /// 進行中か？
    bool isRunning() const;
    /// 終了したか？
    bool isFinished() const;
    /// 終了した瞬間か？(終了したフレームでのみ判定)
    bool isJustFinished() const;
    /// 設定を消去し Finished 状態にする(コールバックも呼ばれない)
    void clear();
    /// 進行させる
    void update();
private:
    class State
        : private ::lib::NonCreatable
    {
    public:
        enum EnumType
        {
            Finished,
            Running,
            JustFinished,
            Infinite,
            TERM
        };
    };
    int mFrame;
    int mFrameLen;
    State::EnumType mState;
    ::lib::Function<void()> mFinishedCallback;
};

} // namespace
// EOF
