﻿// 文字コード:UTF-8
/// @file
#include "lib/Timer.hpp"

//------------------------------------------------------------------------------
namespace lib{

//------------------------------------------------------------------------------
Timer::Timer()
: mFrame(0)
, mFrameLen(0)
, mState(State::Finished)
{
    clear();
}

//------------------------------------------------------------------------------
void Timer::start(int aFrameLen, const ::lib::Function<void()>& aFinishedCallback)
{
    mFrame = 0;
    mFrameLen = aFrameLen;
    mState = State::Running;
    mFinishedCallback = aFinishedCallback;
}

//------------------------------------------------------------------------------
void Timer::startIfNotRunning(int aFrameLen, const ::lib::Function<void()>& aFinishedCallback)
{
    if (!isRunning()) {
        start(aFrameLen, aFinishedCallback);
    }
}

//------------------------------------------------------------------------------
void Timer::startInfinitely()
{
    mFrame = 0;
    mFrameLen = 0;
    mState = State::Infinite;
}

//------------------------------------------------------------------------------
float Timer::getRatio() const
{
    SYS_ASSERT(mFrameLen != 0);
    return((float)mFrame / mFrameLen);
}

//------------------------------------------------------------------------------
bool Timer::isRunning() const
{
    return (mState == State::Running || mState == State::Infinite);
}

//------------------------------------------------------------------------------
bool Timer::isFinished() const
{
    return (mState == State::Finished || mState == State::JustFinished);
}

//------------------------------------------------------------------------------
bool Timer::isJustFinished() const
{
    return (mState == State::JustFinished);
}

//------------------------------------------------------------------------------
void Timer::clear()
{
    mFrame = 0;
    mFrameLen = 0;
    mState = State::Finished;
    mFinishedCallback.clear();
}

//------------------------------------------------------------------------------
void Timer::update()
{
    mFrame += 1;
    if (mFrame >= mFrameLen) {
        switch (mState) {
            case State::Running:
                mState = State::JustFinished;
                mFinishedCallback.callIfValid();
                break;
            case State::Infinite:
                mFrame = 0;
                break;
            case State::JustFinished:
                mState = State::Finished;
                break;
            case State::Finished: break;
            default: SYS_ASSERT_NOT_REACHED(); break;
        }
        mFrame = mFrameLen;
    }
}

} // namespace
// EOF
