﻿// 文字コード:UTF-8
/// @file
#include "lib/StringParser.hpp"

#include <cstdlib>

//------------------------------------------------------------------------------
namespace lib {

//------------------------------------------------------------------------------
int StringParser::ParseDecInt(const char* aStr)
{
    SYS_ASSERT_POINTER(aStr);
    return ::std::strtol(aStr, nullptr, 10);
}

//------------------------------------------------------------------------------
float StringParser::ParseFloat(const char* aStr)
{
    SYS_ASSERT_POINTER(aStr);
    return ::std::strtof(aStr, nullptr);
}

//------------------------------------------------------------------------------
uint64_t StringParser::ParseHexUint64(const char* aStr)
{
    SYS_ASSERT_POINTER(aStr);
    return ::std::strtoull(aStr, nullptr, 16);
}

} // namespace
// EOF
