﻿// 文字コード:UTF-8
/// @file
#pragma once

//------------------------------------------------------------------------------
namespace lib {

/// 矩形
/// ・最小位置とサイズで表わされる
/// ・最小位置以外を利用してしまうと期待挙動とならないメソッドがある点に注意
class Rect
{
public:
    Rect();
    Rect(const ::lib::Vector2& aPosition, const ::lib::Vector2& aSize);
    Rect(float aPosX, float aPosY, float aWidth, float aHeight);
    ::lib::Vector2& position() { return mPosition; }
    const ::lib::Vector2& position() const { return mPosition; }
    ::lib::Vector2& size() { return mSize; }
    const ::lib::Vector2& size() const { return mSize; }
    bool operator==(const Rect& aRect) const;
    bool operator!=(const Rect& aRect) const { return !operator==(aRect); }
    /// 設定する
    void set(const ::lib::Vector2& aPosition, const ::lib::Vector2& aSize);
    /// 矩形が空か？
    bool isEmpty() const;
    /// 面積を計算する
    float getArea() const;
    /// 位置が含まれるか？
    bool contains(const ::lib::Vector2& aPos) const;
    /// 矩形が含まれるか？
    bool contains(const Rect& aRect) const;
    /// 交差するか？
    bool intersects(const Rect& aRect) const;
    /// 交差させる(共通部分の矩形にする)
    void intersect(const Rect& aRect);
    /// 交差させた結果を取得する
    Rect getIntersected(const Rect& aRect) const;
    /// 合体させる
    void unite(const Rect& aRect);
    /// 合体させた結果を取得する
    Rect getUnited(const Rect& aRect) const;
    /// 範囲内に収める
    void clamp(const Rect& aRect);
    /// 範囲内に収めた結果を取得する
    Rect getClamped(const Rect& aRect) const;
    /// 拡張する
    void inflate(float aLen);
    /// 拡張した結果を取得する
    Rect getInflated(float aLen) const;
    /// 拡張する
    void inflate(const ::lib::Vector2& aSize);
    /// 拡張した結果を取得する
    Rect getInflated(const ::lib::Vector2& aSize) const;
    /// 反対位置を取得する
    ::lib::Vector2 getOppositePosition() const;
    /// 中心位置を取得する
    ::lib::Vector2 getCenterPosition() const;
    /// 指定位置に最も近い矩形内の点を返す
    ::lib::Vector2 getNearestPosition(const ::lib::Vector2& aPos) const;
    DEBUG_EVAL(String toString() const);
private:
    ::lib::Vector2 mPosition;
    ::lib::Vector2 mSize;
};
} // namespace
// EOF
