﻿// 文字コード:UTF-8
/// @file
#pragma once

#include <lib/debug/Assert.hpp>
#include <lib/NonCopyable.hpp>

//------------------------------------------------------------------------------
namespace lib {

/// @addtogroup LIB-Util
//@{
/// 2つ以上インスタンスを作ることを許可しないシングルトンクラス。
/// @details
/// このクラスを継承したクラスは
/// ２つ以上インスタンスを作成することができなくなります。
///
/// テンプレート引数に自分のクラスを指定してください。
template<typename TType>
class PrivateSingleton
    : private ::lib::NonCopyable
{
protected:
    inline PrivateSingleton();
    inline ~PrivateSingleton();

private:
    static bool Exists;
};
//@}

//------------------------------------------------------------------------------
template<typename TType>
bool PrivateSingleton<TType>::Exists = false;

//------------------------------------------------------------------------------
template<typename TType>
PrivateSingleton<TType>::PrivateSingleton()
{
    SYS_ASSERT(!Exists);
    Exists = true;
}

//------------------------------------------------------------------------------
template<typename TType>
PrivateSingleton<TType>::~PrivateSingleton()
{
    SYS_ASSERT(Exists);
    Exists = false;
}

} // namespace
// EOF
