﻿// 文字コード:UTF-8
/// @file
#include <lib/Math.hpp>

#include <cfloat>
#include <cmath>
#include <cstdio>
#include <lib/debug/Assert.hpp>
#include <lib/Unused.hpp>

//------------------------------------------------------------------------------
namespace lib {

//------------------------------------------------------------------------------
int Math::SolveQuadraticEquation(const float aCoefA, const float aCoefB,
    const float aCoefC, float* const aOutRoot1, float* const aOutRoot2)
{
    const float discriminant = aCoefB * aCoefB - 4.0f * aCoefA * aCoefC;

    // 解が１個の時
    if (IsZero(discriminant)) {
        *aOutRoot1 = - aCoefB / (2.0f * aCoefA);
        return 1;
    }

    // 解が０個の時
    if (discriminant < 0.0f) {
        return 0;
    }

    // 解が２個の時
    const float factor = (0.0f < aCoefB)
        ? (aCoefB + Sqrt(discriminant)) / (-2.0f)
        : (aCoefB - Sqrt(discriminant)) / (-2.0f);
    *aOutRoot1 = factor / aCoefA;
    *aOutRoot2 = aCoefC / factor;
    return 2;
}

} // namespace
// EOF
