﻿// 文字コード:UTF-8
/// @file
#pragma once

#include "lib/JsonReader.hpp"
#include "lib/Nullable.hpp"

namespace lib { class JsonReader; }

//------------------------------------------------------------------------------
namespace lib {

class JsonValue
{
public:
    class Iterator;

    // @note 文字列をコピーしないため、元データは保持しておく必要があることに注意
    JsonValue(const ::lib::String& aString);
    JsonValue(const char* aString, int aStringLength);
    JsonValue();
    ~JsonValue();

    /// Null か？
    /// @note JSON が正しくない場合は false となることに注意
    bool isNull() const;

    /// 値の取り出し(失敗した場合はアサート)
    bool   toBool() const { return toBoolOrNull().value(); }
    int    toInt() const { return toIntOrNull().value(); }
    float  toFloat() const { return toFloatOrNull().value(); }
    String toString(int aCapacity) const { return toStringOrNull(aCapacity).value(); }
    /// 値の取り出し(失敗した場合はNull)
    Nullable<bool>   toBoolOrNull() const;
    Nullable<int>    toIntOrNull() const;
    Nullable<float>  toFloatOrNull() const;
    Nullable<String> toStringOrNull(int aCapacity) const;

    /// キーに対応する JsonValue を取得する
    JsonValue operator[](const char* aKey) const;

    /// 配列要素を巡回するイテレータ
    /// @note 現状はオブジェクトのキーは巡回できない
    Iterator begin();
    Iterator begin() const;
    Iterator end();
    Iterator end() const;

private:
    JsonValue(const char* aData, const char* aDataEnd) : mData(aData), mDataEnd(aDataEnd) {}
    JsonReader getReader() const;

    const char* mData;
    const char* mDataEnd;
};

//------------------------------------------------------------------------------
class JsonValue::Iterator
{
public:
    Iterator(const JsonValue& aJsonValue) : mJsonValue(aJsonValue) {}

    const JsonValue& operator*() const { return mJsonValue; }
    void operator++();
    bool operator!=(const Iterator& aIterator) const { return aIterator.mJsonValue.mData != mJsonValue.mData; }

private:
    JsonValue mJsonValue;
};

} // namespace
// EOF
