﻿// 文字コード:UTF-8
/// @file
#pragma once

/// @addtogroup LIB-Util
//@{
/// @name 識別子結合
//@{
/// ２つの識別子を連結する。引数がマクロであっても、そのマクロを展開し連結する。
/// @details
/// @code
/// LIB_JOIN(foo, bar) // 結果：foobar
/// LIB_JOIN(foo, __LINE__) // 結果：foo123 (123行目なら)
/// @endcode
///
/// 言語仕様から、引数のマクロを展開するために*_IMPLと二段階にしている。
/// 上記の例の__LINE__のようなケースのため。コンパイラによってはさらに
/// もう一段必要だったり(つまり、*_IMPL_IMPLが必要)することもあるらしいが、
/// 言語仕様的には一段で十分のようなのでこの実装。(2013/05/22 hiroyuki)
#define LIB_JOIN(aSymbol1, aSymbol2) \
    LIB_JOIN_IMPL(aSymbol1, aSymbol2)
//@}
//@}

#define LIB_JOIN_IMPL(aSymbol1, aSymbol2) \
    aSymbol1##aSymbol2

// EOF
