﻿// 文字コード:UTF-8
/// @file
#include <lib/FixedStringImpl.hpp>

#include <cstdio>
#include <cstring>
#include <lib/debug/Assert.hpp>
#include <lib/Unused.hpp>

//------------------------------------------------------------------------------
namespace lib {

//------------------------------------------------------------------------------
int FixedStringImpl::Strcmp(const char* aLhs, const char* aRhs)
{
    return ::std::strcmp(aLhs, aRhs);
}

//------------------------------------------------------------------------------
int FixedStringImpl::Strlen(const char* aStr)
{
    return static_cast<int>(::std::strlen(aStr));
}

//------------------------------------------------------------------------------
void FixedStringImpl::Strncpy(char* aDst, const char* aSrc, int aSize)
{
    SYS_ASSERT(Strlen(aSrc) < aSize);

    ::std::strncpy(aDst, aSrc, aSize);
    aDst[aSize - 1] = '\0';
}

//------------------------------------------------------------------------------
void FixedStringImpl::Append(char* const aDst, const char* const aSrc,
    const int aDstBufferWholeSize)
{
    // * 実装メモ
    // strncat()を用いる。strncatの第３引数のサイズは、
    // 「もしsrcの文字列長が第３引数の値を超える場合、
    // 第３引数の分コピーした上でさらにNUL文字も付加する」という仕様。
    // つまり、+1分書き込まれるので注意。(2014/01/08 hiroyuki)

    const int dstLength = Strlen(aDst);

    // 書き込み可能サイズ。上記のコメントにもあるように、-1する。
    const int writableSize = aDstBufferWholeSize - dstLength - 1;
    SYS_ASSERT3(0 <= writableSize,
        writableSize, dstLength, aDstBufferWholeSize);

    ::std::strncat(aDst, aSrc, writableSize);

    // 長さでアサートをかける。ちゃんとNUL文字も付加されていることも確認
    const int appendedLength = Strlen(aDst);
    LIB_UNUSED(appendedLength);
    SYS_ASSERT2(appendedLength < aDstBufferWholeSize,
        appendedLength, aDstBufferWholeSize);
}

//------------------------------------------------------------------------------
void FixedStringImpl::VPrintf(
    char* aBuffer,
    int aLength,
    va_list aArg,
    const char* aFormat
    )
{
    // stdがついていないのは、GCCの「stdではなくグローバル空間で定義されている」
    // 問題への対処のため。(2013/05/09 hiroyuki)
    const int result = vsnprintf(aBuffer, aLength, aFormat, aArg);
    LIB_UNUSED(result);
    SYS_ASSERT_MSG(0 <= result, "VPrintf error"); // 処理系によっては、バッファ不足時に-1を返す
    SYS_ASSERT_MSG(result < aLength,
        "Require %d  Length %d\n",
        result,
        aLength
        );
}

} // namespace
// EOF
