﻿// 文字コード:UTF-8
/// @file
#pragma once

#include <lib/FixedStringPod.hpp>

//------------------------------------------------------------------------------
namespace lib {

/// @addtogroup LIB-String
//@{

template <int TArgCapacity>
class FixedString
    : public FixedStringPod<TArgCapacity>
{
private:
    typedef FixedStringPod<TArgCapacity> PodType;

public:
    typedef typename PodType::CharType CharType;

    inline FixedString();
    inline FixedString(const PodType& aRhs);
    inline FixedString(const CharType* aStr);
    inline FixedString(::std::va_list aArg, const CharType* aFormat);
};

//@}

//------------------------------------------------------------------------------
template <int TArgCapacity>
FixedString<TArgCapacity>::FixedString()
: PodType()
{
    this->ptr()[0] = '\0';
}

//------------------------------------------------------------------------------
template <int TArgCapacity>
FixedString<TArgCapacity>::FixedString(const PodType& aRhs)
: PodType(aRhs)
{
}

//------------------------------------------------------------------------------
template <int TArgCapacity>
FixedString<TArgCapacity>::FixedString(const CharType* aStr)
: PodType()
{
    this->set(aStr);
}

//------------------------------------------------------------------------------
template <int TArgCapacity>
FixedString<TArgCapacity>::FixedString(::std::va_list aArg, const CharType* aFormat)
: PodType()
{
    FixedStringImpl::VPrintf(this->ptr(), PodType::Capacity, aArg, aFormat);
}

} // namespace
// EOF
