﻿// 文字コード:UTF-8
/// @file
#include <lib/Color4.hpp>

//------------------------------------------------------------------------------
#include <lib/Vector4Pod.hpp>

//------------------------------------------------------------------------------
namespace lib {

//------------------------------------------------------------------------------
Color4::Color4()
: Color4Pod(Zero())
{
}

//------------------------------------------------------------------------------
Color4::Color4(const Color4Pod& aCol)
: Color4Pod(aCol)
{
}

//------------------------------------------------------------------------------
Color4::Color4(const float aR, const float aG, const float aB, const float aA)
{
    r = aR;
    g = aG;
    b = aB;
    a = aA;
}

//------------------------------------------------------------------------------
Color4::Color4(const ::lib::Vector4Pod& aVec)
{
    r = aVec.x;
    g = aVec.y;
    b = aVec.z;
    a = aVec.w;
}

} // namespace
// EOF
