﻿// 文字コード:UTF-8
/// @file
#pragma once

/// 文字列と文字列の長さを「,」区切りで返す(要するにゼロ終端を含まない長さ)
#define LIB_CSTRING_AND_LENGTH(STR) \
    STR, (sizeof(STR) / sizeof(STR[0]) - 1)

/// 文字列配列リテラルと配列の長さを「,」区切りで返す(引数の「const char** aNames, int aLength」に渡す用途)
#define LIB_CSTRING_ARRAY_LITERAL_AND_LENGTH(...) \
    (const char*[]){ __VA_ARGS__ }, (sizeof((const char*[]){ __VA_ARGS__ }) / sizeof(char*))

namespace lib {

/// C方式の文字列を扱うクラス
class CString
{
public:
    static void UnitTest();
    /// 指定文字列長を格納するのに必要な容量を最大値で取得する
    static int GetMaxUtf8CapacityFromUtf16Length(int aStringLength);
    /// 上限指定により、安全に文字列長を取得する
    static int GetLength(const char* aStr, int aCap);
    /// 上限指定により、安全に指定文字までの文字列長を取得する
    static int GetLength(const char* aStr, int aCap, int aCh);
    /// 上限指定により、安全に文字列を比較する
    static int Compare(const char* aS1, const char* aS2, int aCap, bool aWillIgnoreCase = false);
    /// その文字は制御文字か？
    static bool IsControlChar(char aCh) { return aCh <= 0x1f; }
    /// その文字は16進数の1桁を表す文字か？('0','1',...,'e'('E'),'f'('F'))
    static bool IsHexChar(char aCh);
    /// コピー先に必ず終端を付加する文字コピー
    /// @param num バッファの文字数(=バッファのバイト数)
    /// @attention 文字をコピーしきれないときはアサート
    static void Copy(char* aDst, const char* aSrc, int aCap);
    /// コピー先に必ず終端を付加する文字コピー
    /// @param num バッファの文字数(=バッファのバイト数)
    /// @return 全部コピーできたら true 。打ち切りが発生したら false 。
    /// @attention 文字をコピーしきれないときは文字が欠落する
    static bool CopyAsPossible(char* aDst, const char* aSrc, int aCap);
    /// 指定文字列で開始するか？
    static bool StartsWith(const char* aStr, const char* aTargetStr, int aCap);
    /// 指定文字列が文字列に含まれるか？
    static bool Contains(const char* aStr, const char* aSubStr, bool aWillIgnoreCase = false);
    static void Format(char* aStr, int aCap, const char* aFmt, ...);
    static void FormatV(char* aStr, int aCap, const char* aFmt, ::std::va_list aVaList);
    static void FormatAsPossible(char* aStr, int aCap, const char* aFmt, ...);
    static void FormatVAsPossible(char* aStr, int aCap, const char* aFmt, ::std::va_list aVaList);
};

} // namespace
// EOF
