﻿// 文字コード:UTF-8
/// @file
#include "lib/ApproachUtil.hpp"

#include "lib/Math.hpp"

namespace lib {

//------------------------------------------------------------------------------
void ApproachUtil::ApproachByRatioAndThreshold(float* aVal, float aTargetVal, float aRatio, float aThreshold)
{
    SYS_ASSERT_POINTER(aVal);
    if (::lib::Math::Abs(*aVal - aTargetVal) <= aThreshold) {
        *aVal = aTargetVal;
    } else {
        *aVal += aRatio * (aTargetVal - *aVal);
    }
}

//------------------------------------------------------------------------------
void ApproachUtil::ApproachByDelta(float* aVal, float aTargetVal, float aDelta)
{
    SYS_ASSERT_POINTER(aVal);
    if (::lib::Math::Abs(*aVal - aTargetVal) <= aDelta) {
        *aVal = aTargetVal;
    } else {
        *aVal += ((aTargetVal > *aVal) ? 1.0f : -1.0f) * aDelta;
    }
}

} // namespace
// EOF
