﻿// 文字コード:UTF-8
/// @file
#include "WebCommand.hpp"

#include <nn/web.h>

namespace {

const char* fExitReasonToString(::nn::web::WebExitReason aExitReason){
    switch (aExitReason) {
        case ::nn::web::WebExitReason_EndButtonPressed:
            return "EndButtonPressed";
        case ::nn::web::WebExitReason_BackButtonPressed:
            return "BackButtonPressed";
        case ::nn::web::WebExitReason_ExitMessage:
            return "ExitMessage";
        case ::nn::web::WebExitReason_CallbackUrlReached:
            return "CallbackUrlReached";
        case ::nn::web::WebExitReason_LastWindowDeleted:
            return "LastWindowDeleted";
        case ::nn::web::WebExitReason_LocalNetworkDisconnectionDenied:
            return "LocalNetworkDisconnectionDenied";
        case ::nn::web::WebExitReason_MediaPlayerClosed:
            return "MediaPlayerClosed";
        case ::nn::web::WebExitReason_CausedByWebPage:
            return "CausedByWebPage";
        case ::nn::web::WebExitReason_UserSelectionCanceled:
            return "UserSelectionCanceled";
        case ::nn::web::WebExitReason_NetworkConnectionFailed:
            return "NetworkConnectionFailed";
        case ::nn::web::WebExitReason_SystemUpdateRequired:
            return "SystemUpdateRequired";
        case ::nn::web::WebExitReason_Unexpected:
            return "Unexpected";
        default:
            SYS_ASSERT_NOT_REACHED();
    }
    return nullptr;
}

}

//------------------------------------------------------------------------------
bool WebCommand::Command(const InternalArgs& aInternalArgs)
{
    SYS_ASSERT(aInternalArgs.showAppletKind() == InternalArgs::ShowAppletKind::Web);

    ::lib::ScopedPtr<::nn::web::ShowWebPageArg> arg;
    ::nn::web::WebPageReturnValue rValue;

    arg.reset(new ::nn::web::ShowWebPageArg(aInternalArgs.requestUrl().buffer()));
    if (!aInternalArgs.callbackUrl().isEmpty()) {
        arg->SetCallbackUrl(aInternalArgs.callbackUrl().buffer());
    }
    if (!aInternalArgs.callbackableUrl().isEmpty()) {
        arg->SetCallbackableUrl(aInternalArgs.callbackableUrl().buffer());
    }
    arg->SetPointerEnabled(aInternalArgs.isPointerEnabled());
    arg->SetBootAsMediaPlayer(aInternalArgs.isBootAsMediaPlayer());
    arg->SetMediaPlayerAutoCloseEnabled(aInternalArgs.isMediaPlayerAutoCloseEnabled());
    arg->SetWebAudioEnabled(aInternalArgs.isWebAudioEnabled());
    arg->SetLeftStickMode(::nn::web::WebLeftStickMode(aInternalArgs.leftStickMode()));
    arg->SetUid(aInternalArgs.uid());
    arg->SetFooterFixedKind(::nn::web::WebFooterFixedKind(aInternalArgs.footerFixedKind()));
    arg->SetBootDisplayKind(::nn::web::WebBootDisplayKind(aInternalArgs.bootDisplayKind()));
    arg->SetBackgroundKind(::nn::web::WebBackgroundKind(aInternalArgs.backgroundKind()));
    arg->SetJsExtensionEnabled(aInternalArgs.isJsExtensionEnabled());
    arg->SetDisplayUrlKind(::nn::web::WebDisplayUrlKind(aInternalArgs.displayUrlKind()));
    if (!aInternalArgs.userAgentAdditionalString().isEmpty()) {
        arg->SetUserAgentAdditionalString(aInternalArgs.userAgentAdditionalString().buffer());
    }
    arg->SetTouchEnabledOnContents(aInternalArgs.isTouchEnabledOnContents());
    arg->SetPageCacheEnabled(aInternalArgs.isPageCacheEnabled());
    arg->SetPageFadeEnabled(aInternalArgs.isPageFadeEnabled());
    arg->SetPageScrollIndicatorEnabled(aInternalArgs.isPageScrollIndicatorEnabled());
    arg->SetMediaPlayerSpeedControlEnabled(aInternalArgs.isMediaPlayerSpeedControlEnabled());

    auto result = ::nn::web::ShowWebPage(&rValue, *arg);
    if (result.IsFailure()) {
        NN_LOG("WebApplet canceld\n");
    }

    NN_LOG("[OutParam] exitReason: %s\n", fExitReasonToString(rValue.GetWebExitReason()));
    if (rValue.GetWebExitReason() == ::nn::web::WebExitReason_CallbackUrlReached) {
        if (rValue.GetLastUrlSize() > 0) {
            NN_LOG("[OutParam] LastUrl: %s\n", rValue.GetLastUrl());
        }
    }

    return result.IsSuccess();
}

//------------------------------------------------------------------------------
// EOF
