﻿// 文字コード:UTF-8
/// @file
#pragma once

#include <nn/web/web_ShowArg.h>
#include <nn/web/web_OfflineShowArg.h>
#include <nn/web/common/web_CommonTypes.h>

#include "SplitCommand.hpp"

//------------------------------------------------------------------------------
class InternalArgs
{
public:
    enum class ShowAppletKind
    {
        None,
        Web,
        Offline,
    };

    enum class DisplayUrlKind
    {
        FullPath,
        Domain,
    };

    enum class DisplayHelpKind
    {
        None,
        Common,
        Web,
        Offline,
    };

    InternalArgs(const SplitCommand& aSplitCommand);
    ~InternalArgs();

    bool isValid() const { return mIsValid; }
    DisplayHelpKind displayHelpKind() const { return mDisplayHelpKind; }

    ShowAppletKind showAppletKind() const { return mShowAppletKind; }
    const ::lib::String& requestUrl() const { return mRequestUrl; }
    const ::lib::String& callbackUrl() const { return mCallbackUrl; }
    const ::lib::String& callbackableUrl() const { return mCallbackableUrl; }
    const ::lib::String& documentPath() const { return mDocumentPath; }
    const ::lib::String& userAgentAdditionalString() const { return mUserAgentAdditionalString; }
    bool isBootAsMediaPlayer() const { return mIsBootAsMediaPlayer; }
    bool isMediaPlayerAutoCloseEnabled() const { return mIsMediaPlayerAutoCloseEnabled; }
    bool isWebAudioEnabled() const { return mIsWebAudioEnabled; }
    bool isPointerEnabled() const { return mIsPointerEnabled; }
    bool isJsExtensionEnabled() const { return mIsJsExtensionEnabled; }
    bool isFooterEnabled() const { return mIsFooterEnabled; }
    ::nn::web::common::FooterFixedKind footerFixedKind() const { return mFooterFixedKind; }
    bool isTouchEnabledOnContents() const { return mIsTouchEnabledOnContents; }
    bool isPageCacheEnabled() const { return mIsPageCacheEnabled; }
    bool isPageFadeEnabled() const { return mIsPageFadeEnabled; }
    bool isBootLoadingIconEnabled() const { return mIsBootLoadingIconEnabled; }
    bool isPageScrollIndicatorEnabled() const { return mIsPageScrollIndicatorEnabled; }
    ::nn::web::common::LeftStickMode leftStickMode() const { return mLeftStickMode; }
    const ::nn::account::Uid& uid() const { return mUid; }
    ::nn::web::common::BootDisplayKind bootDisplayKind() const { return mBootDisplayKind; }
    ::nn::web::common::BackgroundKind backgroundKind() const { return mBackgroundKind; }
    DisplayUrlKind displayUrlKind() const { return mDisplayUrlKind; }
    int keyRepeatDelayFrame() const{ return mKeyRepeatDelayFrame; }
    int keyRepeatPulseFrame() const{ return mKeyRepeatPulseFrame; }
    bool isMediaPlayerSpeedControlEnabled() const { return mIsMediaPlayerSpeedControlEnabled; }

private:
    DisplayHelpKind needsDisplayHelp(const SplitCommand& aSplitCommand) const;

    bool mIsValid;
    DisplayHelpKind mDisplayHelpKind;

    ShowAppletKind mShowAppletKind;
    ::lib::String mRequestUrl;
    ::lib::String mCallbackUrl;
    ::lib::String mCallbackableUrl;
    ::lib::String mDocumentPath;
    ::lib::String mUserAgentAdditionalString;
    bool mIsBootAsMediaPlayer;
    bool mIsMediaPlayerAutoCloseEnabled;
    bool mIsWebAudioEnabled;
    bool mIsPointerEnabled;
    bool mIsJsExtensionEnabled;
    bool mIsFooterEnabled;
    ::nn::web::common::FooterFixedKind mFooterFixedKind;
    bool mIsTouchEnabledOnContents;
    bool mIsPageCacheEnabled;
    bool mIsPageFadeEnabled;
    bool mIsBootLoadingIconEnabled;
    bool mIsPageScrollIndicatorEnabled;
    ::nn::web::common::LeftStickMode mLeftStickMode;
    ::nn::account::Uid mUid;
    ::nn::web::common::BootDisplayKind mBootDisplayKind;
    ::nn::web::common::BackgroundKind mBackgroundKind;
    DisplayUrlKind mDisplayUrlKind;
    int mKeyRepeatDelayFrame;
    int mKeyRepeatPulseFrame;
    bool mIsMediaPlayerSpeedControlEnabled;
};

//------------------------------------------------------------------------------
// EOF
