﻿// 文字コード:UTF-8
/// @file
#include "InternalArgs.hpp"

#include "sys/account/Account.hpp"

//------------------------------------------------------------------------------
InternalArgs::InternalArgs(const SplitCommand& aSplitCommand)
: mIsValid()
, mDisplayHelpKind(DisplayHelpKind::None)
, mShowAppletKind(ShowAppletKind::None)
, mRequestUrl(::nn::web::ShowWebPageArg::RequestUrlMaxLength)
, mCallbackUrl(::nn::web::ShowWebPageArg::CallbackUrlMaxLength)
, mCallbackableUrl(::nn::web::ShowWebPageArg::CallbackableUrlMaxLength)
, mDocumentPath(::nn::web::ShowOfflineHtmlPageArg::DocumentPathMaxLength)
, mUserAgentAdditionalString(::nn::web::ShowWebPageArg::UserAgentAdditionalStringMaxLength)
, mIsBootAsMediaPlayer(false)
, mIsMediaPlayerAutoCloseEnabled(false)
, mIsWebAudioEnabled(false)
, mIsPointerEnabled(true)
, mIsJsExtensionEnabled(false)
, mIsFooterEnabled(true)
, mFooterFixedKind(::nn::web::common::FooterFixedKind::Auto)
, mIsTouchEnabledOnContents(true)
, mIsPageCacheEnabled(true)
, mIsPageFadeEnabled(true)
, mIsBootLoadingIconEnabled(true)
, mIsPageScrollIndicatorEnabled(false)
, mLeftStickMode(::nn::web::common::LeftStickMode::StickPointer)
, mUid(::nn::account::InvalidUid)
, mBootDisplayKind(::nn::web::common::BootDisplayKind::Default)
, mBackgroundKind(::nn::web::common::BackgroundKind::Normal)
, mDisplayUrlKind(DisplayUrlKind::FullPath)
, mKeyRepeatDelayFrame(-1)
, mKeyRepeatPulseFrame(-1)
, mIsMediaPlayerSpeedControlEnabled(false)
{
    // ヘルプ表示のみが必要かを判定します。
    mDisplayHelpKind = needsDisplayHelp(aSplitCommand);
    if (mDisplayHelpKind != DisplayHelpKind::None) {
        return;
    }

    if (aSplitCommand.hasKey(::SplitCommand::CommandKind::Web)) {
        if (::std::strlen(aSplitCommand.getString(::SplitCommand::CommandKind::Web)) > ::nn::web::ShowWebPageArg::RequestUrlMaxLength - 1) {
            ::ErrorLogger::LogArgumentOmitted(::SplitCommand::ToReadPtr(SplitCommand::CommandKind::Web));
        }
        mRequestUrl.setAsPossible(aSplitCommand.getString(::SplitCommand::CommandKind::Web));
        mShowAppletKind = ShowAppletKind::Web;

        if (aSplitCommand.hasKey(::SplitCommand::CommandKind::UserAgentAdditionalString)) {
            if (::std::strlen(aSplitCommand.getString(::SplitCommand::CommandKind::UserAgentAdditionalString)) > ::nn::web::ShowWebPageArg::UserAgentAdditionalStringMaxLength - 1) {
                ::ErrorLogger::LogArgumentOmitted(::SplitCommand::ToReadPtr(SplitCommand::CommandKind::UserAgentAdditionalString));
            }
            mUserAgentAdditionalString.setAsPossible(aSplitCommand.getString(::SplitCommand::CommandKind::UserAgentAdditionalString));
        }
    }
    else if (aSplitCommand.hasKey(::SplitCommand::CommandKind::Offline)) {
        const char* drivePath = "debug://";
        const auto drivePathLength = ::std::strlen(drivePath);

        ::lib::String documentPath(4096, aSplitCommand.getString(::SplitCommand::CommandKind::Offline));
        if (documentPath.startsWith(drivePath)) {
            if (::std::strlen(documentPath.buffer()) > ::nn::web::ShowOfflineHtmlPageArg::DocumentPathMaxLength - 1) {
                ::ErrorLogger::LogArgumentOmitted(::SplitCommand::ToReadPtr(SplitCommand::CommandKind::Offline));
            }
            mDocumentPath.setAsPossible(documentPath.buffer());
            mShowAppletKind = ShowAppletKind::Offline;
        }
        else {
            if (::std::strlen(documentPath.buffer()) > ::nn::web::ShowOfflineHtmlPageArg::DocumentPathMaxLength - drivePathLength - 1) {
                ::ErrorLogger::LogArgumentOmitted(::SplitCommand::ToReadPtr(SplitCommand::CommandKind::Offline));
            }
            mDocumentPath.setAsPossible(::lib::String::FromFormat(4096 + drivePathLength, "%s%s", drivePath, documentPath.buffer()));
            mShowAppletKind = ShowAppletKind::Offline;
        }
    }

    if (aSplitCommand.hasKey(::SplitCommand::CommandKind::CallbackUrl)) {
        if (::std::strlen(aSplitCommand.getString(::SplitCommand::CommandKind::CallbackUrl)) > ::nn::web::ShowWebPageArg::CallbackUrlMaxLength - 1) {
            ::ErrorLogger::LogArgumentOmitted(::SplitCommand::ToReadPtr(SplitCommand::CommandKind::CallbackUrl));
        }
        mCallbackUrl.setAsPossible(aSplitCommand.getString(::SplitCommand::CommandKind::CallbackUrl));
    }

    if (aSplitCommand.hasKey(::SplitCommand::CommandKind::CallbackableUrl)) {
        if (::std::strlen(aSplitCommand.getString(::SplitCommand::CommandKind::CallbackableUrl)) > ::nn::web::ShowWebPageArg::CallbackableUrlMaxLength - 1) {
            ::ErrorLogger::LogArgumentOmitted(::SplitCommand::ToReadPtr(SplitCommand::CommandKind::CallbackableUrl));
        }
        mCallbackableUrl.setAsPossible(aSplitCommand.getString(::SplitCommand::CommandKind::CallbackableUrl));
    }

    if (aSplitCommand.hasKey(::SplitCommand::CommandKind::BootAsMediaPlayer)) {
        mIsBootAsMediaPlayer = aSplitCommand.getBool(::SplitCommand::CommandKind::BootAsMediaPlayer);
    }

    if (aSplitCommand.hasKey(::SplitCommand::CommandKind::MediaPlayerAutoCloseEnabled)) {
        mIsMediaPlayerAutoCloseEnabled = aSplitCommand.getBool(::SplitCommand::CommandKind::MediaPlayerAutoCloseEnabled);
    }

    if (aSplitCommand.hasKey(::SplitCommand::CommandKind::WebAudioEnabled)) {
        mIsWebAudioEnabled = aSplitCommand.getBool(::SplitCommand::CommandKind::WebAudioEnabled);
    }

    if (aSplitCommand.hasKey(::SplitCommand::CommandKind::PointerEnabled)) {
        mIsPointerEnabled = aSplitCommand.getBool(::SplitCommand::CommandKind::PointerEnabled);
    }

    if (aSplitCommand.hasKey(::SplitCommand::CommandKind::JsExtensionEnabled)) {
        mIsJsExtensionEnabled = aSplitCommand.getBool(::SplitCommand::CommandKind::JsExtensionEnabled);
    }

    if (aSplitCommand.hasKey(::SplitCommand::CommandKind::FooterEnabled)) {
        mIsFooterEnabled = aSplitCommand.getBool(::SplitCommand::CommandKind::FooterEnabled);
    }

    if (aSplitCommand.hasKey(::SplitCommand::CommandKind::FooterFixedKind)) {
        ::lib::ShortString32 autoStr("Auto");
        ::lib::ShortString32 shownStr("Shown");
        auto* arg = aSplitCommand.getString(::SplitCommand::CommandKind::FooterFixedKind);
        if (autoStr.isEquals(arg)) {
            mFooterFixedKind = ::nn::web::common::FooterFixedKind::Auto;
        }
        else if (shownStr.isEquals(arg)) {
            mFooterFixedKind = ::nn::web::common::FooterFixedKind::Shown;
        }
        else {
            ::ErrorLogger::LogIllegalArgument(::SplitCommand::ToReadPtr(SplitCommand::CommandKind::FooterFixedKind), arg);
        }
    }

    if (aSplitCommand.hasKey(::SplitCommand::CommandKind::TouchEnabledOnContents)) {
        mIsTouchEnabledOnContents = aSplitCommand.getBool(::SplitCommand::CommandKind::TouchEnabledOnContents);
    }

    if (aSplitCommand.hasKey(::SplitCommand::CommandKind::PageCacheEnabled)) {
        mIsPageCacheEnabled = aSplitCommand.getBool(::SplitCommand::CommandKind::PageCacheEnabled);
    }

    if (aSplitCommand.hasKey(::SplitCommand::CommandKind::PageFadeEnabled)) {
        mIsPageFadeEnabled = aSplitCommand.getBool(::SplitCommand::CommandKind::PageFadeEnabled);
    }

    if (aSplitCommand.hasKey(::SplitCommand::CommandKind::BootLoadingIconEnabled)) {
        mIsBootLoadingIconEnabled = aSplitCommand.getBool(::SplitCommand::CommandKind::BootLoadingIconEnabled);
    }

    if (aSplitCommand.hasKey(::SplitCommand::CommandKind::PageScrollIndicatorEnabled)) {
        mIsPageScrollIndicatorEnabled = aSplitCommand.getBool(::SplitCommand::CommandKind::PageScrollIndicatorEnabled);
    }

    if (aSplitCommand.hasKey(::SplitCommand::CommandKind::LeftStickMode)) {
        ::lib::ShortString32 spatialNaviStr("SpatialNavi");
        ::lib::ShortString32 stickPointerStr("StickPointer");
        auto* arg = aSplitCommand.getString(::SplitCommand::CommandKind::LeftStickMode);
        if (spatialNaviStr.isEquals(arg)) {
            mLeftStickMode = ::nn::web::common::LeftStickMode::SpatialNavi;
        }
        else if (stickPointerStr.isEquals(arg)) {
            mLeftStickMode = ::nn::web::common::LeftStickMode::StickPointer;
        }
        else {
            ::ErrorLogger::LogIllegalArgument(::SplitCommand::ToReadPtr(SplitCommand::CommandKind::LeftStickMode), arg);
        }
    }

    if (aSplitCommand.hasKey(::SplitCommand::CommandKind::UserIndex)) {
        mUid = ::sys::account::Account::Instance().toUid(aSplitCommand.getInt(::SplitCommand::CommandKind::UserIndex));
    }

    if (aSplitCommand.hasKey(::SplitCommand::CommandKind::BootDisplayKind)) {
        ::lib::ShortString32 defaultStr("Default");
        ::lib::ShortString32 whiteStr("White");
        ::lib::ShortString32 blackStr("Black");
        auto* arg = aSplitCommand.getString(::SplitCommand::CommandKind::BootDisplayKind);
        if (defaultStr.isEquals(arg)) {
            mBootDisplayKind = ::nn::web::common::BootDisplayKind::Default;
        }
        else if (whiteStr.isEquals(arg)) {
            mBootDisplayKind = ::nn::web::common::BootDisplayKind::White;
        }
        else if (blackStr.isEquals(arg)) {
            mBootDisplayKind = ::nn::web::common::BootDisplayKind::Black;
        }
        else {
            ::ErrorLogger::LogIllegalArgument(::SplitCommand::ToReadPtr(SplitCommand::CommandKind::BootDisplayKind), arg);
        }
    }

    if (aSplitCommand.hasKey(::SplitCommand::CommandKind::BackgroundKind)) {
        ::lib::ShortString32 normalStr("Normal");
        ::lib::ShortString32 applicationCaptureStr("ApplicationCapture");
        ::lib::ShortString32 applicationCaptureBlurStr("ApplicationCaptureBlur");
        auto* arg = aSplitCommand.getString(::SplitCommand::CommandKind::BackgroundKind);
        if (normalStr.isEquals(arg)) {
            mBackgroundKind = ::nn::web::common::BackgroundKind::Normal;
        }
        else if (applicationCaptureStr.isEquals(arg)) {
            mBackgroundKind = ::nn::web::common::BackgroundKind::ApplicationCapture;
        }
        else if (applicationCaptureBlurStr.isEquals(arg)) {
            mBackgroundKind = ::nn::web::common::BackgroundKind::ApplicationCaptureBlur;
        }
        else {
            ::ErrorLogger::LogIllegalArgument(::SplitCommand::ToReadPtr(SplitCommand::CommandKind::BackgroundKind), arg);
        }
    }

    if (aSplitCommand.hasKey(::SplitCommand::CommandKind::KeyRepeatDelayFrame)) {
        mKeyRepeatDelayFrame = aSplitCommand.getInt(::SplitCommand::CommandKind::KeyRepeatDelayFrame);
    }

    if (aSplitCommand.hasKey(::SplitCommand::CommandKind::KeyRepeatPulseFrame)) {
        mKeyRepeatPulseFrame = aSplitCommand.getInt(::SplitCommand::CommandKind::KeyRepeatPulseFrame);
    }

    if (aSplitCommand.hasKey(::SplitCommand::CommandKind::DisplayUrlKind)) {
        ::lib::ShortString32 fullpathStr("FullPath");
        ::lib::ShortString32 domainStr("Domain");
        auto* arg = aSplitCommand.getString(::SplitCommand::CommandKind::DisplayUrlKind);
        if (fullpathStr.isEquals(arg)) {
            mDisplayUrlKind = DisplayUrlKind::FullPath;
        }
        else if (domainStr.isEquals(arg)) {
            mDisplayUrlKind = DisplayUrlKind::Domain;
        }
        else {
            ::ErrorLogger::LogIllegalArgument(::SplitCommand::ToReadPtr(SplitCommand::CommandKind::DisplayUrlKind), arg);
        }
    }

    if (aSplitCommand.hasKey(::SplitCommand::CommandKind::MediaPlayerSpeedControlEnabled)) {
        mIsMediaPlayerSpeedControlEnabled = aSplitCommand.getBool(::SplitCommand::CommandKind::MediaPlayerSpeedControlEnabled);
    }

    if (mShowAppletKind != ShowAppletKind::None) {
        mIsValid = true;
    }
}

//------------------------------------------------------------------------------
InternalArgs::~InternalArgs()
{
    mIsValid = false;
}

//------------------------------------------------------------------------------
InternalArgs::DisplayHelpKind InternalArgs::needsDisplayHelp(const SplitCommand& aSplitCommand) const
{
    if (aSplitCommand.hasKey(::SplitCommand::CommandKind::Help)) {
        if (aSplitCommand.hasKey(::SplitCommand::CommandKind::Web)) {
            return DisplayHelpKind::Web;
        }
        else if (aSplitCommand.hasKey(::SplitCommand::CommandKind::Offline)) {
            return DisplayHelpKind::Offline;
        }
        else {
            return DisplayHelpKind::Common;
        }
    }
    return DisplayHelpKind::None;
}

//------------------------------------------------------------------------------
// EOF
