﻿// 文字コード:UTF-8
/// @file
#include "ErrorLogger.hpp"

//------------------------------------------------------------------------------

namespace {

// 各メッセージはDevMenuCommandに合わせています。

const char fHelpMessage[] =
    "usage: " WEBCALLERCOMMAND_NAME " <command> [<args>]\n"
    "\n"
    "The " WEBCALLERCOMMAND_NAME " commands are:\n"
    "   web <requestUrl>       ShowWebApplet\n"
    "   offline <documentPath> ShowOfflineApplet\n"
    "";

const char fWebHelpMessage[] =
    "usage: " WEBCALLERCOMMAND_NAME " web <requestUrl>\n"
    "   [--callback-url <callbackUrl>]\n"
    "   [--callbackable-url <callbackableUrl>]\n"
    "   [--boot-as-media-player <true|false>]\n"
    "   [--media-player-auto-close-enabled <true|false>]\n"
    "   [--web-audio-enabled <true|false>]\n"
    "   [--pointer-enabled <true|false>]\n"
    "   [--left-stick-mode <SpatialNavi|StickPointer>]\n"
    "   [--user-index <userIndex>]\n"
    "   [--footer-fixed-kind <Auto|Shown>]\n"
    "   [--boot-display-kind <Default|White|Black>]\n"
    "   [--background-kind <Normal|ApplicationCapture|ApplicationCaptureBlur>]\n"
    "   [--js-extension-enabled <true|false>]\n"
    "   [--display-url-kind <FullPath|Domain>]\n"
    "   [--user-agent-additional-string <userAgentAdditionalString>]\n"
    "   [--touch-enabled-on-contents <true|false>]\n"
    "   [--page-cache-enabled <true|false>]\n"
    "   [--page-fade-enabled <true|false>]\n"
    "   [--page-scroll-indicator-enabled <true|false>]\n"
    "   [--media-player-speed-control-enabled <true|false>]\n"
    "";

const char fOfflineHelpMessage[] =
    "usage: " WEBCALLERCOMMAND_NAME " offline <documentPath>\n"
    "   [--boot-as-media-player <true|false>]\n"
    "   [--media-player-auto-close-enabled <true|false>]\n"
    "   [--web-audio-enabled <true|false>]\n"
    "   [--pointer-enabled <true|false>]\n"
    "   [--left-stick-mode <SpatialNavi|StickPointer>]\n"
    "   [--footer-enabled <true|false>]\n"
    "   [--footer-fixed-kind <Auto|Shown>]\n"
    "   [--boot-display-kind <Default|White|Black>]\n"
    "   [--background-kind <Normal|ApplicationCapture|ApplicationCaptureBlur>]\n"
    "   [--key-repeat-delay-frame <frame>]\n"
    "   [--key-repeat-pulse-frame <frame>]\n"
    "   [--js-extension-enabled <true|false>]\n"
    "   [--touch-enabled-on-contents <true|false>]\n"
    "   [--page-cache-enabled <true|false>]\n"
    "   [--page-fade-enabled <true|false>]\n"
    "   [--boot-loading-icon-enabled <true|false>]\n"
    "   [--page-scroll-indicator-enabled <true|false>]\n"
    "   [--media-player-speed-control-enabled <true|false>]\n"
    "";

const char fIllegalArgumentMessage[] =
    "'%s' is not a " WEBCALLERCOMMAND_NAME " %s command."
    " See '" WEBCALLERCOMMAND_NAME " %s --help'.\n"
    "";

const char fNotEnoughMessage[] =
    "not enough argument for %s command."
    " See '" WEBCALLERCOMMAND_NAME " %s --help'.\n"
    "";

const char fArgumentOmittedMessage[] =
    "argument '%s' is omitted.\n";

}

//------------------------------------------------------------------------------
void ErrorLogger::LogHelp()
{
    NN_LOG(fHelpMessage);
}

//------------------------------------------------------------------------------
void ErrorLogger::LogWebHelp()
{
    NN_LOG(fWebHelpMessage);
}

//------------------------------------------------------------------------------
void ErrorLogger::LogOfflineHelp()
{
    NN_LOG(fOfflineHelpMessage);
}

//------------------------------------------------------------------------------
void ErrorLogger::LogIllegalArgument(const char* aCommand, const char* aArg)
{
    SYS_ASSERT_POINTER(aCommand);
    SYS_ASSERT_POINTER(aArg);
    NN_LOG(fIllegalArgumentMessage, aArg, aCommand, aCommand);
}

//------------------------------------------------------------------------------
void ErrorLogger::LogNotEnough(const char* aCommand)
{
    SYS_ASSERT_POINTER(aCommand);
    NN_LOG(fNotEnoughMessage, aCommand, aCommand);
}

//------------------------------------------------------------------------------
void ErrorLogger::LogArgumentOmitted(const char* aArg)
{
    SYS_ASSERT_POINTER(aArg);
    NN_LOG(fArgumentOmittedMessage, aArg);
}


//------------------------------------------------------------------------------
// EOF
