#!bash

CurDir=$(cygpath -m $(cd $(dirname $0); pwd))

set -e
if [ -z "$NINTENDO_SDK_ROOT" ]; then
    echo Error: NINTENDO_SDK_ROOT is not set or the path is not specified on parameters.
    exit 1
fi

if [ -e $CurDir/WebCallerCommand.nsp ]; then
    webCallerCommand="$NINTENDO_SDK_ROOT/Tools/CommandLineTools/RunOnTarget.exe $CurDir/WebCallerCommand.nsp --"
else
    echo WebCallerCommand not found.
fi

$webCallerCommand $*
