﻿/*---------------------------------------------------------------------------*
  Copyright (C)2015 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#include <nn/os.h>
#include <nn/nn_Abort.h>
#include <nn/nn_SdkLog.h>

extern "C" {

#include <sys/types.h>
#include <sys/param.h>
#include <sys/kernel.h>
#include <sys/malloc.h>
#include <siglo/network.h>

static void clear_sinaddr(struct sockaddr_in *sin)
{
    bzero(sin, sizeof(*sin));
    sin->sin_len = sizeof(*sin);
    sin->sin_family = AF_INET;
    sin->sin_addr.s_addr = INADDR_ANY;
    sin->sin_port = 0;
}

#define NEXTADDR(u)                                                 \
    do                                                              \
    {                                                               \
            l = (((struct sockaddr *)(u))->sa_len == 0) ?           \
                sizeof(long) :                                      \
                1 + ((((struct sockaddr *)(u))->sa_len - 1)         \
                    | (sizeof(long) - 1));                          \
            memmove(cp, (char *)(u), l);                            \
            cp += l;                                                \
    } while(0)


/* init loopback interface, add route */
static void lo_sysinit(void* dummy)
{
    struct sockaddr_in addr;
    struct sockaddr_in *sinip, *sinmask, *sinbroad;
    struct sockaddr_in *sindst;
    struct ifreq ifr;
    struct ifaliasreq ifra;
    static struct {
        struct  rt_msghdr m_rtm;
        char    m_space[512];
    } m_rtmsg;
    char *cp = m_rtmsg.m_space;
    int s;
    int one = 1;
    int l;
    int seq = 0;

    memset((void*)&ifr,  0, sizeof(ifr));
    memset((void*)&ifra, 0, sizeof(ifra));
    memset((void*)&m_rtmsg,  0, sizeof(m_rtmsg));

    /* init loop if */
    s = socketsocket(AF_INET, SOCK_DGRAM, 0, DEFAULT_PID);
    if (s < 0) {
        return;
    }
    if (socketsetsockopt(s, SOL_SOCKET, SO_BROADCAST, &one, sizeof(one), DEFAULT_PID)) {
        socketclose(s, DEFAULT_PID);
        return;
    }
    strcpy(ifra.ifra_name, "lo0");
    strcpy(ifr.ifr_name,   "lo0");
    sinip    = (struct sockaddr_in *)&ifra.ifra_addr;
    sinmask  = (struct sockaddr_in *)&ifra.ifra_mask;
    sinbroad = (struct sockaddr_in *)&ifra.ifra_broadaddr;
    sindst   = (struct sockaddr_in *)&addr;
    clear_sinaddr(sinip);
    clear_sinaddr(sinmask);
    clear_sinaddr(sinbroad);
    sinip->sin_family = AF_INET;
    sinip->sin_addr.s_addr   = htonl(INADDR_LOOPBACK);
    sinmask->sin_addr.s_addr = htonl(IN_CLASSA_NET);
    sinbroad->sin_family = AF_INET;
    sinbroad->sin_addr.s_addr = htonl(INADDR_LOOPBACK);
    if (socketioctl(s, SIOCAIFADDR, (caddr_t)&ifra, sizeof(ifra), DEFAULT_PID)) {
        printf("failed to set loop if address\n");
        socketclose(s, DEFAULT_PID);
        return;
    }
    ifr.ifr_addr  = ifra.ifra_addr;
    ifr.ifr_flags = IFF_UP | IFF_BROADCAST | IFF_RUNNING | IFF_LOOPBACK;
    if (socketioctl(s, SIOCSIFFLAGS, (caddr_t)&ifr, sizeof(ifr), DEFAULT_PID)) {
        printf("failed to start loop if\n");
        socketclose(s, DEFAULT_PID);
        return;
    }
    socketclose(s, DEFAULT_PID);

    /* set route */
    s = socketsocket(PF_ROUTE, SOCK_RAW, 0, DEFAULT_PID);
    if (s < 0) {
        printf("failed to open route socket\n");
        return;
    }
    clear_sinaddr(sindst);
    sindst->sin_family        = AF_INET;
    sindst->sin_addr.s_addr   = htonl(INADDR_LOOPBACK);
    m_rtmsg.m_rtm.rtm_type    = RTM_ADD;
    m_rtmsg.m_rtm.rtm_flags   = RTF_GATEWAY | RTF_UP;
    m_rtmsg.m_rtm.rtm_version = RTM_VERSION;
    m_rtmsg.m_rtm.rtm_addrs   = RTA_NETMASK | RTA_GATEWAY | RTA_DST;
    m_rtmsg.m_rtm.rtm_seq     = ++seq;
    NEXTADDR(sindst);
    NEXTADDR(sinip);
    NEXTADDR(sinmask);
    m_rtmsg.m_rtm.rtm_msglen = l = cp - (char*)&m_rtmsg;
    if (socketwrite(s, (char*)&m_rtmsg, l, DEFAULT_PID) < 0) {
        printf("failed to set loop route\n");
    }
    socketclose(s, DEFAULT_PID);
    return;
}

SYSINIT(lo_sysinit, SI_SUB_LAST, SI_ORDER_ANY, lo_sysinit, NULL);

FORCE_LINK_THIS(_loop_);

}
