﻿/*---------------------------------------------------------------------------*
  Copyright (C)2015 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#include <nn/os.h>
#include <nn/nn_Abort.h>
#include <nn/nn_SdkLog.h>

extern "C" {

#include <sys/types.h>
#include <sys/param.h>
#include <sys/systm.h>

char   const hex2ascii_data[] = "0123456789abcdefghijklmnopqrstuvwxyz";
static const int MAX_DEBUG_STRING = 256;
int    bootverbose;

struct snprintf_arg {
    char* str;
    size_t size;
};

static void snprintf_func(int ch, void * arg)
{
    struct snprintf_arg *info = (struct snprintf_arg*)arg;
    if (info->size >= 2) {
        *info->str++ = ch;
        info->size--;
    }
}


int vsnprintf(char* str, size_t size, const char *format, va_list ap)
{
    int rval;
    struct snprintf_arg info;
    info.str  = str;
    info.size = size;
    rval = kvprintf(format, snprintf_func, (void*)&info, 10, ap);
    if (info.size >= 1) {
        *info.str++ = '\0';
    }
    return rval;
}


void log(int l, const char *msg, ...)
{
    char buf[MAX_DEBUG_STRING];
    va_list ap;
    va_start(ap, msg);
    vsnprintf(buf, sizeof(buf), msg, ap);
    va_end(ap);
    NN_SDK_LOG(buf);
    return;
}

int printf(const char *msg, ...)
{
    char buf[MAX_DEBUG_STRING];
    int  rval;
    va_list ap;
    va_start(ap, msg);
    rval = vsnprintf(buf, sizeof(buf), msg, ap);
    va_end(ap);
    NN_SDK_LOG(buf);
    return rval;
}

int snprintf(char *buf, size_t size, const char *cfmt, ...)
{
    int retval;
    va_list ap;
    struct snprintf_arg arg;

    arg.str  = buf;
    arg.size = size;

    va_start(ap, cfmt);
    retval = kvprintf(cfmt, &snprintf_func, &arg, 10, ap);
    va_end(ap);

    if (arg.size >= 1)
        *(arg.str)++ = 0;
    return retval;
}

}

