﻿/*---------------------------------------------------------------------------*
  Copyright (C)2015 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#include <nn/os.h>
#include <nn/nn_Abort.h>
#include <nn/nn_SdkLog.h>

extern "C" {

#include <sys/types.h>
#include <sys/param.h>
#include <sys/lock.h>

struct lock_class lock_class_rm;
struct lock_class lock_class_rm_sleepable;
struct lock_class lock_class_lockmgr;

struct lock_class *lock_classes[LOCK_CLASS_MAX + 1] = {
        &lock_class_mtx_spin,
        &lock_class_mtx_sleep,
        &lock_class_sx,
        &lock_class_rm,
        &lock_class_rm_sleepable,
        &lock_class_rw,
        &lock_class_lockmgr,
};

void lock_init(
        struct lock_object *lock, struct lock_class *l_class,
        const char *name, const char *type, int flags)
{
    int i;
    for (i = 0; i < LOCK_CLASS_MAX; i++) {
        if (lock_classes[i] == l_class) {
            lock->lo_flags = i << LO_CLASSSHIFT;
            break;
        }
    }
    NN_ABORT_UNLESS(i < LOCK_CLASS_MAX);
    lock->lo_name   = name;
    lock->lo_flags |= flags | LO_INITIALIZED;
    return;
}

}
