﻿/*---------------------------------------------------------------------------*
  Copyright (C)2015 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

/* Few of the modules register themselves during startup, until they do
 * other files may not reference them and linker's optimization logic
 * discards them. The code below force references those files.
 */

#include <sys/types.h>
#include <sys/param.h>

extern "C" {

#include <sys/malloc.h>
#include <sys/kernel.h>
#include <opt/opt_inet6.h>

MALLOC_DEFINE(M_TEMP,   "temp",   "misc temporary data buffers");

FORCE_LINK_THAT(_ip_carp_);
FORCE_LINK_THAT(_loop_);
FORCE_LINK_THAT(_time_);
FORCE_LINK_THAT(_bpf_);
FORCE_LINK_THAT(_bpf_buffer_);
FORCE_LINK_THAT(_bpf_filter_);
FORCE_LINK_THAT(_bpf_zerocopy_);
FORCE_LINK_THAT(_if_);
FORCE_LINK_THAT(_if_clone_);
FORCE_LINK_THAT(_if_dead_);
FORCE_LINK_THAT(_if_ethersubr_);
FORCE_LINK_THAT(_if_llatbl_);
FORCE_LINK_THAT(_if_loop_);
FORCE_LINK_THAT(_netisr_);
FORCE_LINK_THAT(_pfil_);
FORCE_LINK_THAT(_radix_);
FORCE_LINK_THAT(_raw_cb_);
FORCE_LINK_THAT(_raw_usrreq_);
FORCE_LINK_THAT(_route_);
FORCE_LINK_THAT(_rtsock_);
FORCE_LINK_THAT(_if_ether_);
FORCE_LINK_THAT(_igmp_);
FORCE_LINK_THAT(_in_);
FORCE_LINK_THAT(_in_cksum_);
FORCE_LINK_THAT(_in_mcast_);
FORCE_LINK_THAT(_in_pcb_);
FORCE_LINK_THAT(_in_proto_);
FORCE_LINK_THAT(_in_rmx_);
FORCE_LINK_THAT(_ip_ecn_);
FORCE_LINK_THAT(_ip_encap_);
FORCE_LINK_THAT(_ip_fastfwd_);
FORCE_LINK_THAT(_ip_icmp_);
FORCE_LINK_THAT(_ip_id_);
FORCE_LINK_THAT(_ip_input_);
FORCE_LINK_THAT(_ip_mroute_);
FORCE_LINK_THAT(_ip_options_);
FORCE_LINK_THAT(_ip_output_);
FORCE_LINK_THAT(_raw_ip_);
FORCE_LINK_THAT(_tcp_debug_);
FORCE_LINK_THAT(_tcp_hostcache_);
FORCE_LINK_THAT(_tcp_input_);
FORCE_LINK_THAT(_tcp_output_);
FORCE_LINK_THAT(_tcp_reass_);
FORCE_LINK_THAT(_tcp_sack_);
FORCE_LINK_THAT(_tcp_subr_);
FORCE_LINK_THAT(_tcp_syncache_);
FORCE_LINK_THAT(_tcp_timer_);
FORCE_LINK_THAT(_tcp_timewait_);
FORCE_LINK_THAT(_tcp_usrreq_);
FORCE_LINK_THAT(_udp_usrreq_);
#if defined(INET6)
FORCE_LINK_THAT(_dest6_);
FORCE_LINK_THAT(_frag6_);
FORCE_LINK_THAT(_icmp6_);
FORCE_LINK_THAT(_in6_);
FORCE_LINK_THAT(_in6_cksum_);
FORCE_LINK_THAT(_in6_ifattach_);
FORCE_LINK_THAT(_in6_mcast_);
FORCE_LINK_THAT(_in6_pcb_);
FORCE_LINK_THAT(_in6_pcbgroup_);
FORCE_LINK_THAT(_in6_proto_);
FORCE_LINK_THAT(_in6_rmx_);
FORCE_LINK_THAT(_in6_src_);
FORCE_LINK_THAT(_ip6_forward_);
FORCE_LINK_THAT(_ip6_id_);
FORCE_LINK_THAT(_ip6_input_);
FORCE_LINK_THAT(_ip6_mroute_);
FORCE_LINK_THAT(_ip6_output_);
FORCE_LINK_THAT(_mld6_);
FORCE_LINK_THAT(_nd6_);
FORCE_LINK_THAT(_nd6_nbr_);
FORCE_LINK_THAT(_nd6_rtr_);
FORCE_LINK_THAT(_raw_ip6_);
FORCE_LINK_THAT(_route6_);
FORCE_LINK_THAT(_scope6_);
FORCE_LINK_THAT(_udp6_usrreq_);
#endif
FORCE_LINK_THAT(_proc_);
FORCE_LINK_THAT(__cc__);
FORCE_LINK_THAT(__cc_newreno__);
FORCE_LINK_THAT(__cc_cubic__);
FORCE_LINK_THAT(_sysctl_);

}
